/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImportedImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideExportDialog;
import org.openstreetmap.josm.plugins.streetside.io.export.StreetsideExportManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class StreetsideExportAction
extends JosmAction {
    private static final long serialVersionUID = 6131359489725632369L;
    static final Logger logger = Logger.getLogger(StreetsideExportAction.class);
    private StreetsideExportDialog dialog;

    public StreetsideExportAction() {
        super(I18n.tr((String)"Export Streetside images", (Object[])new Object[0]), new ImageProvider(StreetsidePlugin.LOGO).setSize(ImageProvider.ImageSizes.DEFAULT), I18n.tr((String)"Export Streetside images", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Export Streetside", (String)I18n.tr((String)"Export Streetside images", (Object[])new Object[0]), (int)65535, (int)5000), false, "streetsideExport", true);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent ae) {
        JOptionPane pane = new JOptionPane();
        JButton ok = new JButton("Ok");
        ok.addActionListener(e -> pane.setValue(0));
        JButton cancel = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        cancel.addActionListener(e -> pane.setValue(2));
        this.dialog = new StreetsideExportDialog(ok);
        pane.setMessage(this.dialog);
        pane.setOptions(new JButton[]{ok, cancel});
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Export Streetside images", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0 && this.dialog.chooser != null) {
            if (this.dialog.group.isSelected(this.dialog.all.getModel())) {
                this.export(StreetsideLayer.getInstance().getData().getImages());
            } else if (this.dialog.group.isSelected(this.dialog.sequence.getModel())) {
                ConcurrentSkipListSet<StreetsideAbstractImage> images = new ConcurrentSkipListSet<StreetsideAbstractImage>();
                for (StreetsideAbstractImage image : StreetsideLayer.getInstance().getData().getMultiSelectedImages()) {
                    if (image instanceof StreetsideImage) {
                        if (images.contains(image)) continue;
                        images.addAll(image.getSequence().getImages());
                        continue;
                    }
                    images.add(image);
                }
                this.export(images);
            } else if (this.dialog.group.isSelected(this.dialog.selected.getModel())) {
                this.export(StreetsideLayer.getInstance().getData().getMultiSelectedImages());
            }
        } else if (this.dialog.group.isSelected(this.dialog.rewrite.getModel())) {
            ArrayList<StreetsideImportedImage> images = new ArrayList<StreetsideImportedImage>();
            StreetsideLayer.getInstance().getData().getImages().stream().filter(img -> img instanceof StreetsideImportedImage).forEach(img -> images.add((StreetsideImportedImage)img));
            try {
                MainApplication.worker.execute((Runnable)((Object)new StreetsideExportManager(images)));
            }
            catch (IOException e1) {
                logger.error(e1);
            }
        }
        dlg.dispose();
    }

    public void export(Set<StreetsideAbstractImage> images) {
        MainApplication.worker.execute((Runnable)((Object)new StreetsideExportManager(images, this.dialog.chooser.getSelectedFile().toString())));
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.setEnabled(StreetsideLayer.hasInstance());
    }
}

