/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.pointinfo.ReverseRecord;
import org.openstreetmap.josm.tools.HttpClient;

public class ReverseFinder {
    public static final String NOMINATIM_URL = "https://nominatim.openstreetmap.org/reverse?format=json&lat=%f&lon=%f";

    private ReverseFinder() {
    }

    public static ReverseRecord queryNominatim(LatLon pos) throws IOException {
        String request = String.format(Locale.ENGLISH, NOMINATIM_URL, pos.lat(), pos.lon());
        String result = HttpClient.create((URL)new URL(request)).connect().fetchContent();
        JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8)));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        ReverseRecord record = new ReverseRecord(obj);
        return record;
    }
}

