/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class InputStreamReaderUnbuffered
extends Reader {
    private final CharsetDecoder charsetDecoder;
    private final InputStream inputStream;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1);

    public InputStreamReaderUnbuffered(InputStream in, Charset charset) {
        this.inputStream = in;
        this.charsetDecoder = charset.newDecoder();
    }

    @Override
    public int read() throws IOException {
        boolean middleOfReading = false;
        while (true) {
            int b;
            if ((b = this.inputStream.read()) == -1) {
                if (middleOfReading) {
                    throw new IOException("Unexpected end of stream, byte truncated");
                }
                return -1;
            }
            this.byteBuffer.clear();
            this.byteBuffer.put((byte)b);
            this.byteBuffer.flip();
            CharBuffer charBuffer = this.charsetDecoder.decode(this.byteBuffer);
            if (charBuffer.length() > 1) {
                throw new IOException("Decoded multiple characters from one byte!");
            }
            if (charBuffer.length() == 1) {
                return charBuffer.get();
            }
            middleOfReading = true;
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[i] = (char)ch;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

