/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.MissingSectionException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.NoSingleSectionException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.LittleEndian;

public class PropertySet {
    static final byte[] BYTE_ORDER_ASSERTION = new byte[]{-2, -1};
    protected int byteOrder;
    static final byte[] FORMAT_ASSERTION = new byte[]{0, 0};
    protected int format;
    protected int osVersion;
    public static final int OS_WIN32 = 2;
    protected ClassID classID;
    protected List<Section> sections;

    public int getByteOrder() {
        return this.byteOrder;
    }

    public int getFormat() {
        return this.format;
    }

    public int getOSVersion() {
        return this.osVersion;
    }

    public ClassID getClassID() {
        return this.classID;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public List<Section> getSections() {
        return this.sections;
    }

    protected PropertySet() {
    }

    public PropertySet(InputStream inputStream) throws NoPropertySetStreamException, MarkUnsupportedException, IOException, UnsupportedEncodingException {
        if (!PropertySet.isPropertySetStream(inputStream)) {
            throw new NoPropertySetStreamException();
        }
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, byArray.length);
        this.init(byArray, 0, byArray.length);
    }

    public static boolean isPropertySetStream(InputStream inputStream) throws MarkUnsupportedException, IOException {
        if (!inputStream.markSupported()) {
            throw new MarkUnsupportedException(inputStream.getClass().getName());
        }
        inputStream.mark(50);
        byte[] byArray = new byte[50];
        int n = inputStream.read(byArray, 0, Math.min(byArray.length, inputStream.available()));
        boolean bl = PropertySet.isPropertySetStream(byArray, 0, n);
        inputStream.reset();
        return bl;
    }

    public static boolean isPropertySetStream(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = LittleEndian.getUShort(byArray, n3);
        n3 += 2;
        byte[] byArray2 = new byte[2];
        LittleEndian.putShort(byArray2, (short)n4);
        if (!Util.equal(byArray2, BYTE_ORDER_ASSERTION)) {
            return false;
        }
        int n5 = LittleEndian.getUShort(byArray, n3);
        n3 += 2;
        byArray2 = new byte[2];
        LittleEndian.putShort(byArray2, (short)n5);
        if (!Util.equal(byArray2, FORMAT_ASSERTION)) {
            return false;
        }
        n3 += 4;
        long l = LittleEndian.getUInt(byArray, n3 += 16);
        n3 += 4;
        return l >= 0L;
    }

    private void init(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        int n3 = n;
        this.byteOrder = LittleEndian.getUShort(byArray, n3);
        this.format = LittleEndian.getUShort(byArray, n3 += 2);
        this.osVersion = (int)LittleEndian.getUInt(byArray, n3 += 2);
        this.classID = new ClassID(byArray, n3 += 4);
        int n4 = LittleEndian.getInt(byArray, n3 += 16);
        n3 += 4;
        if (n4 < 0) {
            throw new HPSFRuntimeException("Section count " + n4 + " is negative.");
        }
        this.sections = new ArrayList<Section>(n4);
        for (int i = 0; i < n4; ++i) {
            Section section = new Section(byArray, n3);
            n3 += 20;
            this.sections.add(section);
        }
    }

    public boolean isSummaryInformation() {
        if (this.sections.size() <= 0) {
            return false;
        }
        return Util.equal(this.sections.get(0).getFormatID().getBytes(), SectionIDMap.SUMMARY_INFORMATION_ID);
    }

    public boolean isDocumentSummaryInformation() {
        if (this.sections.size() <= 0) {
            return false;
        }
        return Util.equal(this.sections.get(0).getFormatID().getBytes(), SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
    }

    public Property[] getProperties() throws NoSingleSectionException {
        return this.getFirstSection().getProperties();
    }

    protected Object getProperty(int n) throws NoSingleSectionException {
        return this.getFirstSection().getProperty(n);
    }

    protected boolean getPropertyBooleanValue(int n) throws NoSingleSectionException {
        return this.getFirstSection().getPropertyBooleanValue(n);
    }

    protected int getPropertyIntValue(int n) throws NoSingleSectionException {
        return this.getFirstSection().getPropertyIntValue(n);
    }

    public boolean wasNull() throws NoSingleSectionException {
        return this.getFirstSection().wasNull();
    }

    public Section getFirstSection() {
        if (this.getSectionCount() < 1) {
            throw new MissingSectionException("Property set does not contain any sections.");
        }
        return this.sections.get(0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PropertySet)) {
            return false;
        }
        PropertySet propertySet = (PropertySet)object;
        int n = propertySet.getByteOrder();
        int n2 = this.getByteOrder();
        ClassID classID = propertySet.getClassID();
        ClassID classID2 = this.getClassID();
        int n3 = propertySet.getFormat();
        int n4 = this.getFormat();
        int n5 = propertySet.getOSVersion();
        int n6 = this.getOSVersion();
        int n7 = propertySet.getSectionCount();
        int n8 = this.getSectionCount();
        if (n != n2 || !classID.equals(classID2) || n3 != n4 || n5 != n6 || n7 != n8) {
            return false;
        }
        return Util.equals(this.getSections(), propertySet.getSections());
    }

    public int hashCode() {
        throw new UnsupportedOperationException("FIXME: Not yet implemented.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getSectionCount();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("byteOrder: ");
        stringBuffer.append(this.getByteOrder());
        stringBuffer.append(", classID: ");
        stringBuffer.append(this.getClassID());
        stringBuffer.append(", format: ");
        stringBuffer.append(this.getFormat());
        stringBuffer.append(", OSVersion: ");
        stringBuffer.append(this.getOSVersion());
        stringBuffer.append(", sectionCount: ");
        stringBuffer.append(n);
        stringBuffer.append(", sections: [\n");
        List<Section> list = this.getSections();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i).toString());
        }
        stringBuffer.append(']');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

