/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.npm;

import java.util.Objects;
import org.netbeans.modules.keyring.gnome.GnomeProvider;
import org.netbeans.modules.keyring.kde.KWalletProvider;
import org.netbeans.modules.keyring.mac.MacProvider;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openstreetmap.josm.plugins.npm.Win32Provider;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public enum NPMType {
    PLAIN("josm-standard", null, "default", I18n.tr((String)"Plain text, JOSM default", (Object[])new Object[0])),
    GNOME_KEYRING("gnome-keyring", GnomeProvider.class, "gnome-keyring", I18n.tr((String)"Use {0}", (Object[])new Object[]{"gnome-keyring"})),
    KWALLET("kwallet", KWalletProvider.class, "KWallet", I18n.tr((String)"Use {0}", (Object[])new Object[]{"KWallet"})),
    KEYCHAIN("keychain", MacProvider.class, "Apple Keychain", I18n.tr((String)"Use {0}", (Object[])new Object[]{"Mac OS X Keychain"})),
    CRYPT32("crypt32", Win32Provider.class, "Windows data encryption", I18n.tr((String)"Encrypt data with Windows logon credentials", (Object[])new Object[0]));

    private final String prefString;
    private final Class<? extends KeyringProvider> providerClass;
    private final String name;
    private KeyringProvider provider;
    private final String introText;
    private final String selectionText;

    private static String genericIntro(String name) {
        return I18n.tr((String)"The native password manager plugin detected {0} on your system.", (Object[])new Object[]{name});
    }

    private NPMType(String prefString, Class<? extends KeyringProvider> providerClass, String name, String selectionText) {
        this.prefString = prefString;
        this.providerClass = providerClass;
        this.name = name;
        this.introText = NPMType.genericIntro(name);
        this.selectionText = selectionText;
    }

    public static NPMType fromPrefString(String pref) {
        for (NPMType t : NPMType.values()) {
            if (!Objects.equals(pref, t.prefString)) continue;
            return t;
        }
        return null;
    }

    public String toPrefString() {
        return this.prefString;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public String getIntroText() {
        return this.introText;
    }

    public String getName() {
        return this.name;
    }

    public KeyringProvider getProvider() {
        if (this.providerClass == null) {
            return null;
        }
        if (this.provider == null) {
            try {
                this.provider = this.providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                throw new JosmRuntimeException((Throwable)ex);
            }
        }
        return this.provider;
    }
}

