/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamInputData;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamLayer;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamMarker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

class GPSBlamMode
extends MapMode
implements LayerManager.LayerChangeListener,
MouseWheelListener,
AWTEventListener {
    Point pointPressed;
    private Point oldP2;
    int radius = 10;
    MouseWheelListener[] mapViewWheelListeners;
    GPSBlamLayer currentBlamLayer;

    GPSBlamMode(String name, String desc) {
        super(name, "gpsblam_mode.png", desc, Cursor.getPredefinedCursor(1));
    }

    public void enterMode() {
        super.enterMode();
        MapView mapView = MainApplication.getMap().mapView;
        mapView.addMouseListener((MouseListener)((Object)this));
        mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        mapView.addMouseWheelListener((MouseWheelListener)this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.error((Throwable)ex);
        }
        this.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            if (ke.getKeyCode() == 38) {
                this.changeRadiusBy(1);
            } else if (ke.getKeyCode() == 40) {
                this.changeRadiusBy(-1);
            }
        }
    }

    public void exitMode() {
        super.exitMode();
        this.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseWheelListener((MouseWheelListener)this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pointPressed = new Point(e.getPoint());
            for (MouseWheelListener l : this.mapViewWheelListeners = MainApplication.getMap().mapView.getMouseWheelListeners()) {
                if (l == this) continue;
                MainApplication.getMap().mapView.removeMouseWheelListener(l);
            }
            this.paintBox(this.pointPressed, this.radius);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.paintBox(e.getPoint(), this.radius);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        for (MouseWheelListener l : this.mapViewWheelListeners) {
            if (l == this) continue;
            MainApplication.getMap().mapView.addMouseWheelListener(l);
        }
        this.xorDrawBox(this.pointPressed, this.oldP2, this.radius);
        GPSBlamInputData inputData = new GPSBlamInputData(this.pointPressed, e.getPoint(), this.radius);
        if (!inputData.isEmpty()) {
            if (this.currentBlamLayer == null) {
                this.currentBlamLayer = new GPSBlamLayer(I18n.tr((String)"GPSBlam", (Object[])new Object[0]));
                this.getLayerManager().addLayer((Layer)this.currentBlamLayer);
            }
            this.currentBlamLayer.addBlamMarker(new GPSBlamMarker(inputData));
            MainApplication.getMap().mapView.repaint();
        }
        this.oldP2 = null;
        this.pointPressed = null;
    }

    private void changeRadiusBy(int delta) {
        if (this.pointPressed != null) {
            int newRadius = this.radius + delta;
            if (newRadius < 1) {
                newRadius = 1;
            }
            this.paintBox(this.oldP2, newRadius);
            this.radius = newRadius;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.changeRadiusBy(-e.getWheelRotation());
        }
    }

    private void xorDrawBox(Point p1, Point p2, int radius) {
        if (MainApplication.getMap() != null) {
            double length;
            Graphics2D g = (Graphics2D)MainApplication.getMap().mapView.getGraphics();
            g.setXORMode(Color.BLACK);
            g.setColor(Color.WHITE);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setStroke(new BasicStroke(2.0f));
            if (p2 == null) {
                p2 = p1;
            }
            if ((length = Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y))) > 0.0) {
                double dirY;
                double dirX = (double)(p2.x - p1.x) / length;
                double perpdirX = dirY = (double)(p2.y - p1.y) / length;
                double perpdirY = -dirX;
                double angle = Math.atan2(-perpdirY, perpdirX);
                double ofsX = (double)radius * perpdirX;
                double ofsY = (double)radius * perpdirY;
                Path2D.Double path = new Path2D.Double();
                path.append(new Line2D.Double((double)p1.x + ofsX, (double)p1.y + ofsY, (double)p2.x + ofsX, (double)p2.y + ofsY), false);
                path.append(new Arc2D.Double(p2.x - radius, p2.y - radius, radius * 2, radius * 2, Math.toDegrees(angle), -180.0, 0), true);
                path.append(new Line2D.Double((double)p2.x - ofsX, (double)p2.y - ofsY, (double)p1.x - ofsX, (double)p1.y - ofsY), true);
                path.append(new Arc2D.Double(p1.x - radius, p1.y - radius, radius * 2, radius * 2, Math.toDegrees(angle) - 180.0, -180.0, 0), true);
                path.closePath();
                g.draw(path);
            } else {
                try {
                    g.setXORMode(Color.BLACK);
                    g.setColor(Color.WHITE);
                    g.drawOval(Math.round(p2.x - radius), Math.round(p2.y - radius), Math.round(radius * 2), Math.round(radius * 2));
                }
                catch (InternalError e) {
                    Logging.error((Throwable)e);
                    Logging.error((String)"Java bug JDK-8041647 occured. To avoid this bug, please consult https://bugs.openjdk.java.net/browse/JDK-8041647. If the bug is fixed, please update your Java Runtime Environment.");
                }
            }
        }
    }

    private void paintBox(Point p2, int newRadius) {
        if (MainApplication.getMap() != null) {
            if (this.oldP2 != null) {
                this.xorDrawBox(this.pointPressed, this.oldP2, this.radius);
            }
            this.xorDrawBox(this.pointPressed, p2, newRadius);
            this.oldP2 = p2;
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof GPSBlamLayer) {
            this.currentBlamLayer = null;
            if (MainApplication.getMap().mapMode instanceof GPSBlamMode) {
                MainApplication.getMap().selectSelectTool(false);
            }
        }
    }
}

