/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.ejml.data.CMatrix;
import org.ejml.data.Complex_F32;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.ZMatrix;
import org.ejml.ops.ReadMatrixCsv;

public class MatrixIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBin(DMatrix A, String fileName) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(fileName);
        ObjectOutputStream stream = new ObjectOutputStream(fileStream);
        try {
            stream.writeObject(A);
            stream.flush();
        }
        finally {
            try {
                stream.close();
            }
            finally {
                fileStream.close();
            }
        }
    }

    public static <T extends DMatrix> T loadBin(String fileName) throws IOException {
        DMatrix ret;
        FileInputStream fileStream = new FileInputStream(fileName);
        ObjectInputStream stream = new ObjectInputStream(fileStream);
        try {
            ret = (DMatrix)stream.readObject();
            if (stream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        stream.close();
        return (T)ret;
    }

    public static void saveCSV(DMatrix A, String fileName) throws IOException {
        PrintStream fileStream = new PrintStream(fileName);
        fileStream.println(A.getNumRows() + " " + A.getNumCols() + " real");
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumCols(); ++j) {
                fileStream.print(A.get(i, j) + " ");
            }
            fileStream.println();
        }
        fileStream.close();
    }

    public static DMatrixRMaj loadCSV(String fileName) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        DMatrixRMaj ret = (DMatrixRMaj)csv.read();
        fileStream.close();
        return ret;
    }

    public static DMatrixRMaj loadCSV(String fileName, int numRows, int numCols) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        DMatrixRMaj ret = csv.readReal(numRows, numCols);
        fileStream.close();
        return ret;
    }

    public static void print(PrintStream out, DMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, DMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, DMatrix mat, String format) {
        String type = ReshapeMatrix.class.isAssignableFrom(mat.getClass()) ? "dense64" : "dense64 fixed";
        out.println("Type = " + type + " real , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, FMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, FMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f ";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, FMatrix mat, String format) {
        String type = mat.getClass().getSimpleName();
        out.println("Type = " + type + " , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, DMatrix mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = format + " ";
        for (int y = row0; y < row1; ++y) {
            for (int x = col0; x < col1; ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, FMatrix mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = format + " ";
        for (int y = row0; y < row1; ++y) {
            for (int x = col0; x < col1; ++x) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, ZMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, CMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, ZMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f + %" + numChar + "." + precision + "fi";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, CMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f + %" + numChar + "." + precision + "fi";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, ZMatrix mat, String format) {
        String type = "dense64";
        out.println("Type = " + type + " complex , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        Complex_F64 c = new Complex_F64();
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                mat.get(y, x, c);
                out.printf(format, c.real, c.imaginary);
                if (x >= mat.getNumCols() - 1) continue;
                out.print(" , ");
            }
            out.println();
        }
    }

    public static void print(PrintStream out, CMatrix mat, String format) {
        String type = "dense32";
        out.println("Type = " + type + " complex , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        Complex_F32 c = new Complex_F32();
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                mat.get(y, x, c);
                out.printf(format, Float.valueOf(c.real), Float.valueOf(c.imaginary));
                if (x >= mat.getNumCols() - 1) continue;
                out.print(" , ");
            }
            out.println();
        }
    }
}

