/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block.linsol.chol;

import org.ejml.data.DMatrixRBlock;
import org.ejml.data.DSubmatrixD1;
import org.ejml.dense.block.MatrixOps_DDRB;
import org.ejml.dense.block.TriangularSolver_DDRB;
import org.ejml.dense.block.decomposition.chol.CholeskyOuterForm_DDRB;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class CholeskyOuterSolver_DDRB
implements LinearSolverDense<DMatrixRBlock> {
    private CholeskyOuterForm_DDRB decomposer = new CholeskyOuterForm_DDRB(true);
    private int blockLength;
    private double[] temp;

    @Override
    public boolean setA(DMatrixRBlock A) {
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.blockLength = A.blockLength;
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps_DDRM.qualityTriangular(this.decomposer.getT((DMatrixRBlock)null));
    }

    @Override
    public void solve(DMatrixRBlock B, DMatrixRBlock X) {
        if (B.blockLength != this.blockLength) {
            throw new IllegalArgumentException("Unexpected blocklength in B.");
        }
        DSubmatrixD1 L = new DSubmatrixD1(this.decomposer.getT((DMatrixRBlock)null));
        if (X != null) {
            if (X.blockLength != this.blockLength) {
                throw new IllegalArgumentException("Unexpected blocklength in X.");
            }
            if (X.numRows != L.col1) {
                throw new IllegalArgumentException("Not enough rows in X");
            }
        }
        if (B.numRows != L.col1) {
            throw new IllegalArgumentException("Not enough rows in B");
        }
        TriangularSolver_DDRB.solve(this.blockLength, false, L, new DSubmatrixD1(B), false);
        TriangularSolver_DDRB.solve(this.blockLength, false, L, new DSubmatrixD1(B), true);
        if (X != null) {
            MatrixOps_DDRB.extractAligned(B, X);
        }
    }

    @Override
    public void invert(DMatrixRBlock A_inv) {
        DMatrixRBlock T = this.decomposer.getT((DMatrixRBlock)null);
        if (A_inv.numRows != T.numRows || A_inv.numCols != T.numCols) {
            throw new IllegalArgumentException("Unexpected number or rows and/or columns");
        }
        if (this.temp == null || this.temp.length < this.blockLength * this.blockLength) {
            this.temp = new double[this.blockLength * this.blockLength];
        }
        MatrixOps_DDRB.zeroTriangle(true, A_inv);
        DSubmatrixD1 L = new DSubmatrixD1(T);
        DSubmatrixD1 B = new DSubmatrixD1(A_inv);
        TriangularSolver_DDRB.invert(this.blockLength, false, L, B, this.temp);
        TriangularSolver_DDRB.solveL(this.blockLength, L, B, true);
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return true;
    }

    @Override
    public CholeskyDecomposition_F64<DMatrixRBlock> getDecomposition() {
        return this.decomposer;
    }
}

