/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;

final class DataSetToCmd {
    private final DataSet sourceDataSet;
    private final Map<PrimitiveId, OsmPrimitive> mergedMap = new HashMap<PrimitiveId, OsmPrimitive>();
    private final LinkedList<Command> cmds = new LinkedList();

    public DataSetToCmd(DataSet sourceDataSet) {
        this.sourceDataSet = sourceDataSet;
        this.merge();
    }

    private void mergePrimitive(OsmPrimitive source) {
        Node target = null;
        switch (source.getType()) {
            case NODE: {
                target = new Node();
                break;
            }
            case WAY: {
                target = new Way();
                break;
            }
            case RELATION: {
                target = new Relation();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        target.mergeFrom(source);
        this.mergedMap.put(source.getPrimitiveId(), (OsmPrimitive)target);
        this.cmds.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)target));
    }

    private OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) throws IllegalStateException {
        OsmPrimitive target = this.mergedMap.get(mergeSource.getPrimitiveId());
        if (target == null) {
            return null;
        }
        return target;
    }

    public void fixReferences() {
        for (Way w : this.sourceDataSet.getWays()) {
            this.mergeNodeList(w);
        }
        for (Relation r : this.sourceDataSet.getRelations()) {
            this.mergeRelationMembers(r);
        }
    }

    private void mergeNodeList(Way source) throws IllegalStateException {
        Way target = (Way)this.getMergeTarget((OsmPrimitive)source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for way with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        if (target.getDataSet() != null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for way with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget((OsmPrimitive)sourceNode);
            if (targetNode == null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for node with id {0}", (Object[])new Object[]{sourceNode.getUniqueId()}));
            }
            if (targetNode.getDataSet() != null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for way with id {0}", (Object[])new Object[]{source.getUniqueId()}));
            }
            newNodes.add(targetNode);
        }
        this.cmds.add((Command)new ChangeNodesCommand(MainApplication.getLayerManager().getEditDataSet(), target, newNodes));
    }

    private void mergeRelationMembers(Relation source) throws IllegalStateException {
        Relation target = (Relation)this.getMergeTarget((OsmPrimitive)source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for relation with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        if (target.getDataSet() != null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for relation with id {0}", (Object[])new Object[]{source.getUniqueId()}));
        }
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember == null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target of type {0} with id {1}", (Object[])new Object[]{sourceMember.getType(), sourceMember.getUniqueId()}));
            }
            if (targetMember.getDataSet() != null) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target of type {0} with id {1}", (Object[])new Object[]{sourceMember.getType(), sourceMember.getUniqueId()}));
            }
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
        }
        Relation newRelation = new Relation(target);
        newRelation.setMembers(newMembers);
        this.cmds.add((Command)new ChangeCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)target, (OsmPrimitive)newRelation));
    }

    private void merge() {
        for (Node node : this.sourceDataSet.getNodes()) {
            this.mergePrimitive((OsmPrimitive)node);
        }
        for (Way way : this.sourceDataSet.getWays()) {
            this.mergePrimitive((OsmPrimitive)way);
        }
        for (Relation relation : this.sourceDataSet.getRelations()) {
            this.mergePrimitive((OsmPrimitive)relation);
        }
        this.fixReferences();
    }

    public LinkedList<Command> getCommandList() {
        return this.cmds;
    }
}

