/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

public class DataSetChangesetBuilder {
    public static final int MAX_LINK_LENGTH = 102400;
    private DataSet dataSet;

    public BoundedChangesetDataSet build(String dataString) {
        this.dataSet = new DataSet();
        JsonReader reader = Json.createReader((Reader)new StringReader(dataString));
        JsonObject jsonObject = reader.readObject();
        JsonArray array = jsonObject.getJsonArray("elements");
        for (int i = 0; i < array.size(); ++i) {
            JsonObject old;
            JsonObject obj = ((JsonValue)array.get(i)).asJsonObject();
            String action = obj.getString("action");
            String type = obj.getString("type");
            JsonObject tags = obj.getJsonObject("tags");
            if (action.equals("delete") && type.equals("node") && !obj.isNull("old")) {
                old = obj.getJsonObject("old");
                this.processPoint(tags, old, action);
                continue;
            }
            if (action.equals("delete") && type.equals("way") && !obj.isNull("old")) {
                old = obj.getJsonObject("old");
                this.processLineString(tags, old, action);
                continue;
            }
            if (action.equals("create") && type.equals("node")) {
                this.processPoint(tags, obj, action);
                continue;
            }
            if (action.equals("create") && type.equals("way")) {
                this.processLineString(tags, obj, action);
                continue;
            }
            if (action.equals("modify") && type.equals("way")) {
                this.processLineString(tags, obj, "modify-new");
                old = obj.getJsonObject("old");
                this.processLineString(tags, old, "modify-old");
                continue;
            }
            if (action.equals("modify") && type.equals("node")) {
                this.processPoint(tags, obj, "modify-new");
                old = obj.getJsonObject("old");
                this.processPoint(tags, old, "modify-old");
                continue;
            }
            if (action.equals("modify") && type.equals("relation")) {
                old = obj.getJsonObject("old");
                Bounds boundsRelationOld = this.buildRelation(tags, old, "modify-old-rel");
                this.bounds2rectangle(tags, boundsRelationOld, "modify-old-rel");
                Bounds boundsRelationNew = this.buildRelation(tags, obj, "modify-new-rel");
                this.bounds2rectangle(tags, boundsRelationNew, "modify-new-rel");
                continue;
            }
            if (action.equals("create") && type.equals("relation")) {
                Bounds boundsRelationNew = this.buildRelation(tags, obj, "create-rel");
                this.bounds2rectangle(tags, boundsRelationNew, "create-rel");
                continue;
            }
            if (!action.equals("delete") || !type.equals("relation")) continue;
            old = obj.getJsonObject("old");
            Bounds boundsRelationNew = this.buildRelation(tags, old, "delete-rel");
            this.bounds2rectangle(tags, boundsRelationNew, "delete-rel");
        }
        Bounds bounds = null;
        for (OsmPrimitive osmPrimitive : this.dataSet.allPrimitives()) {
            bounds = this.mergeBounds(bounds, osmPrimitive);
        }
        return new BoundedChangesetDataSet(this.dataSet, bounds);
    }

    private void processPoint(JsonObject tags, JsonObject nodeJson, String action) {
        Double lat = Double.parseDouble(nodeJson.getString("lat"));
        Double lon = Double.parseDouble(nodeJson.getString("lon"));
        LatLon latLon = new LatLon(lat.doubleValue(), lon.doubleValue());
        Node node = this.createNode(latLon);
        this.fillTagsFromFeature(tags, (OsmPrimitive)node, action);
    }

    private void processLineString(JsonObject tags, JsonObject wayJson, String action) {
        JsonArray arrayNodes = wayJson.getJsonArray("nodes");
        if (arrayNodes.isEmpty()) {
            return;
        }
        LinkedList<LatLon> coordinates = new LinkedList<LatLon>();
        for (int i = 0; i < arrayNodes.size(); ++i) {
            Double lat = Double.parseDouble(arrayNodes.getJsonObject(i).getString("lat"));
            Double lon = Double.parseDouble(arrayNodes.getJsonObject(i).getString("lon"));
            LatLon latLon = new LatLon(lat.doubleValue(), lon.doubleValue());
            coordinates.add(latLon);
        }
        Way way = this.createWay(coordinates);
        this.fillTagsFromFeature(tags, (OsmPrimitive)way, action);
    }

    private void fillTagsFromFeature(JsonObject tags, OsmPrimitive primitive, String action) {
        if (tags != null) {
            primitive.setKeys(this.getTags(tags, action));
        }
    }

    private Node createNode(LatLon latLon) {
        Node node = new Node(latLon);
        this.dataSet.addPrimitive((OsmPrimitive)node);
        return node;
    }

    private Way createWay(List<LatLon> coordinates) {
        if (coordinates.isEmpty()) {
            return null;
        }
        Way way = new Way();
        ArrayList<Node> nodes = new ArrayList<Node>(coordinates.size());
        for (LatLon point : coordinates) {
            Node node = this.createNode(point);
            nodes.add(node);
        }
        way.setNodes(nodes);
        this.dataSet.addPrimitive((OsmPrimitive)way);
        return way;
    }

    private Map<String, String> getTags(JsonObject tags, String action) {
        TreeMap<String, String> mapTags = new TreeMap<String, String>();
        mapTags.put("action", action);
        for (Map.Entry entry : tags.entrySet()) {
            mapTags.put((String)entry.getKey(), String.valueOf(((JsonValue)entry.getValue()).toString()));
        }
        return mapTags;
    }

    private Bounds mergeBounds(Bounds bounds, OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return this.mergeBounds(bounds, ((Node)osmPrimitive).getCoor());
        }
        return bounds;
    }

    private Bounds mergeBounds(Bounds bounds, LatLon coords) {
        if (bounds == null) {
            return new Bounds(coords);
        }
        bounds.extend(coords);
        return bounds;
    }

    private Bounds getBoundsRelation(Bounds bounds, OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return this.mergeBounds(bounds, ((Node)osmPrimitive).getCoor());
        }
        return bounds;
    }

    private void bounds2rectangle(JsonObject tags, Bounds bounds, String action) {
        Double minLat = bounds.getMinLat();
        Double minLon = bounds.getMinLon();
        Double maxLat = bounds.getMaxLat();
        Double maxLon = bounds.getMaxLon();
        ArrayList<Node> nodes = new ArrayList<Node>(4);
        Node n1 = new Node(new LatLon(minLat.doubleValue(), minLon.doubleValue()));
        this.dataSet.addPrimitive((OsmPrimitive)n1);
        nodes.add(n1);
        Node n2 = new Node(new LatLon(minLat.doubleValue(), maxLon.doubleValue()));
        this.dataSet.addPrimitive((OsmPrimitive)n2);
        nodes.add(n2);
        Node n3 = new Node(new LatLon(maxLat.doubleValue(), maxLon.doubleValue()));
        this.dataSet.addPrimitive((OsmPrimitive)n3);
        nodes.add(n3);
        Node n4 = new Node(new LatLon(maxLat.doubleValue(), minLon.doubleValue()));
        this.dataSet.addPrimitive((OsmPrimitive)n4);
        nodes.add(n4);
        Node n5 = new Node(new LatLon(minLat.doubleValue(), minLon.doubleValue()));
        this.dataSet.addPrimitive((OsmPrimitive)n5);
        nodes.add(n5);
        Way way = new Way();
        way.setNodes(nodes);
        this.fillTagsFromFeature(tags, (OsmPrimitive)way, action);
        this.dataSet.addPrimitive((OsmPrimitive)way);
    }

    private Bounds buildRelation(JsonObject tags, JsonObject obj, String action) {
        DataSet dataSetRel = new DataSet();
        JsonArray members = obj.getJsonArray("members");
        for (int j = 0; j < members.size(); ++j) {
            JsonObject member = members.getJsonObject(j);
            if (member.getString("type").equals("way")) {
                dataSetRel.addPrimitive((OsmPrimitive)this.processRelationLineString(tags, member, dataSetRel));
                continue;
            }
            if (!member.getString("type").equals("node")) continue;
            dataSetRel.addPrimitive((OsmPrimitive)this.processRelationPoint(tags, member));
        }
        Bounds boundsRelationOld = null;
        for (OsmPrimitive osmPrimitive : dataSetRel.allPrimitives()) {
            boundsRelationOld = this.mergeBounds(boundsRelationOld, osmPrimitive);
        }
        return boundsRelationOld;
    }

    private Node processRelationPoint(JsonObject tags, JsonObject nodeJson) {
        Double lat = Double.parseDouble(nodeJson.getString("lat"));
        Double lon = Double.parseDouble(nodeJson.getString("lon"));
        LatLon latLon = new LatLon(lat.doubleValue(), lon.doubleValue());
        Node node = new Node(latLon);
        return node;
    }

    private Way processRelationLineString(JsonObject tags, JsonObject wayJson, DataSet dataSetOld) {
        JsonArray arrayNodes = wayJson.getJsonArray("nodes");
        Way way = new Way();
        if (arrayNodes.isEmpty()) {
            return way;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(arrayNodes.size());
        for (int i = 0; i < arrayNodes.size(); ++i) {
            Double lat = Double.parseDouble(arrayNodes.getJsonObject(i).getString("lat"));
            Double lon = Double.parseDouble(arrayNodes.getJsonObject(i).getString("lon"));
            LatLon latLon = new LatLon(lat.doubleValue(), lon.doubleValue());
            Node node = new Node(latLon);
            dataSetOld.addPrimitive((OsmPrimitive)node);
            nodes.add(node);
        }
        way.setNodes(nodes);
        return way;
    }

    public static class BoundedChangesetDataSet {
        private final DataSet dataSet;
        private final Bounds bounds;

        public BoundedChangesetDataSet(DataSet dataSet, Bounds bounds) {
            this.dataSet = dataSet;
            this.bounds = bounds;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }
    }
}

