/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.CommentBugDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustServiceCommand;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.tools.I18n;

public class ExecuteCommentBug
extends MapdustExecuteAction
implements MapdustBugObservable,
MapdustActionObservable {
    private static final long serialVersionUID = 4391634740784919337L;
    private final ArrayList<MapdustBugObserver> bugObservers = new ArrayList();
    private final ArrayList<MapdustActionObserver> actionObservers = new ArrayList();

    public ExecuteCommentBug() {
    }

    public ExecuteCommentBug(CommentBugDialog dialog, MapdustGUI mapdustGUI) {
        this.setDialog(dialog);
        this.setMapdustGUI(mapdustGUI);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton btn;
        if (event.getSource() instanceof JButton && (btn = (JButton)event.getSource()).getText().equals("OK")) {
            String commentText;
            CommentBugDialog issueDialog = (CommentBugDialog)this.getDialog();
            String nickname = issueDialog.getTxtNickname().getText();
            String errorMessage = this.validate(nickname, commentText = issueDialog.getTxtComment().getText());
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Missing input data", (Object[])new Object[0]), 2);
                return;
            }
            Main.pref.put("mapdust.nickname", nickname);
            MapdustBug selectedBug = this.mapdustGUI.getSelectedBug();
            MapdustComment comment = new MapdustComment(selectedBug.getId(), commentText, nickname);
            String pluginState = Main.pref.get("mapdust.pluginState");
            if (pluginState.equals(MapdustPluginState.OFFLINE.getValue())) {
                String iconPath = this.getIconPath(selectedBug);
                MapdustAction mapdustAction = new MapdustAction(MapdustServiceCommand.COMMENT_BUG, iconPath, selectedBug, comment);
                this.enableFiredButton(issueDialog.getFiredButton());
                this.mapdustGUI.enableBtnPanel(true);
                this.mapdustGUI.getPanel().resetSelectedBug(0);
                issueDialog.dispose();
                if (this.getMapdustGUI().getActionPanel() != null) {
                    issueDialog.dispose();
                    this.notifyObservers(mapdustAction);
                }
            } else {
                MapdustServiceHandler handler = new MapdustServiceHandler();
                Long id = null;
                try {
                    id = handler.commentBug(comment);
                }
                catch (MapdustServiceHandlerException e) {
                    errorMessage = "There was a Mapdust service error.";
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                }
                if (id != null) {
                    MapdustBug newMapdustBug = null;
                    try {
                        newMapdustBug = handler.getBug(selectedBug.getId(), null);
                    }
                    catch (MapdustServiceHandlerException e) {
                        errorMessage = "There was a Mapdust service error.";
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                    }
                    this.enableFiredButton(issueDialog.getFiredButton());
                    this.mapdustGUI.enableBtnPanel(false);
                    this.mapdustGUI.getPanel().resetSelectedBug(0);
                    issueDialog.dispose();
                    if (newMapdustBug != null) {
                        this.notifyObservers(newMapdustBug);
                    }
                }
            }
        }
    }

    @Override
    public void addObserver(MapdustBugObserver observer) {
        if (!this.bugObservers.contains(observer)) {
            this.bugObservers.add(observer);
        }
    }

    @Override
    public void addObserver(MapdustActionObserver observer) {
        if (!this.actionObservers.contains(observer)) {
            this.actionObservers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugObserver observer) {
        this.bugObservers.remove(observer);
    }

    @Override
    public void removeObserver(MapdustActionObserver observer) {
        this.actionObservers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugObserver> elements = this.bugObservers.iterator();
        while (elements.hasNext()) {
            elements.next().changedData(mapdustBug);
        }
    }

    @Override
    public void notifyObservers(MapdustAction mapdustAction) {
        Iterator<MapdustActionObserver> elements = this.actionObservers.iterator();
        while (elements.hasNext()) {
            elements.next().addAction(mapdustAction);
        }
    }
}

