/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

public class CadastreSessionExporter
implements SessionLayerExporter {
    private WMSLayer layer;
    private JCheckBox export;

    public CadastreSessionExporter(WMSLayer layer) {
        this.layer = layer;
    }

    public Collection<Layer> getDependencies() {
        return Collections.emptySet();
    }

    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        lbl.setToolTipText(this.layer.getToolTipText());
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue((int)1, (int)0), GBC.std().fill(2));
        return p;
    }

    public boolean shallExport() {
        return this.export.isSelected();
    }

    public boolean requiresZip() {
        return false;
    }

    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerEl = support.createElement("layer");
        layerEl.setAttribute("type", "cadastre-fr");
        layerEl.setAttribute("version", "0.1");
        Element file = support.createElement("file");
        layerEl.appendChild(file);
        URI uri = this.layer.getAssociatedFile().toURI();
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        file.appendChild(support.createTextNode(url.toString()));
        return layerEl;
    }
}

