/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.api;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class CadastreAPI {
    private static final String API_ENDPOINT = "https://sandbox.geo.api.gouv.fr/cadastre/";

    private CadastreAPI() {
    }

    public static Set<String> getSheets(Bounds bounds) throws IOException {
        return CadastreAPI.getSheets(bounds.getMinLon(), bounds.getMinLat(), bounds.getMaxLon(), bounds.getMaxLat());
    }

    public static Set<String> getSheets(double minlon, double minlat, double maxlon, double maxlat) throws IOException {
        try {
            return Json.createReader((Reader)new StringReader(HttpClient.create((URL)new URL("https://sandbox.geo.api.gouv.fr/cadastre//feuilles?bbox=" + String.join((CharSequence)",", Double.toString(minlon), Double.toString(minlat), Double.toString(maxlon), Double.toString(maxlat)))).connect().fetchContent())).readArray().stream().map(x -> x.asJsonObject().getString("id")).collect(Collectors.toSet());
        }
        catch (MalformedURLException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }
}

