/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Function;
import java.util.logging.Level;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class BoundsDownloadRunnable
implements Runnable {
    protected Bounds bounds;

    protected abstract Function<Bounds, URL> getUrlGenerator();

    public BoundsDownloadRunnable(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public void run() {
        URL nextURL = this.getUrlGenerator().apply(this.bounds);
        try {
            while (nextURL != null) {
                if (Thread.interrupted()) {
                    Logging.debug((String)"{} for {} interrupted!", (Object[])new Object[]{this.getClass().getSimpleName(), this.bounds.toString()});
                    return;
                }
                URLConnection con = nextURL.openConnection();
                this.run(con);
                nextURL = StreetsideURL.APIv3.parseNextFromLinkHeaderValue(con.getHeaderField("Link"));
            }
        }
        catch (IOException e) {
            String message = I18n.tr((String)"Could not read from URL {0}!", (Object[])new Object[]{nextURL.toString()});
            Logging.log((Level)Logging.LEVEL_WARN, (String)message, (Throwable)e);
            if (!GraphicsEnvironment.isHeadless()) {
                new Notification(message).setIcon((Icon)StreetsidePlugin.LOGO.setSize(ImageProvider.ImageSizes.LARGEICON).get()).setDuration(Notification.TIME_LONG).show();
            }
            e.printStackTrace();
        }
    }

    public static void logConnectionInfo(URLConnection con, String info) throws IOException {
        StringBuilder message = con instanceof HttpURLConnection ? new StringBuilder(((HttpURLConnection)con).getRequestMethod()).append(' ').append(con.getURL()).append(" \u2192 ").append(((HttpURLConnection)con).getResponseCode()) : new StringBuilder("Download from ").append(con.getURL());
        if (info != null && info.length() >= 1) {
            message.append(" (").append(info).append(')');
        }
        Logging.info((String)message.toString());
    }

    public abstract void run(URLConnection var1) throws IOException;
}

