/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.actions.ImageReloadAction;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ThreeSixtyDegreeViewerPanel;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.WebLinkAction;
import org.openstreetmap.josm.plugins.streetside.utils.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideViewerPanel
extends JPanel
implements StreetsideDataListener {
    private static final long serialVersionUID = 4141847503072417190L;
    private JCheckBox highResImageryCheck;
    private WebLinkAction imgLinkAction;
    private ImageReloadAction imgReloadAction;
    private AbstractProperty.ValueChangeListener<Boolean> imageLinkChangeListener;
    private static ThreeSixtyDegreeViewerPanel threeSixtyDegreeViewerPanel;

    public StreetsideViewerPanel() {
        super(new BorderLayout());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StreetsideViewerPanel.this.initializeAndStartGUI();
            }
        });
        this.selectedImageChanged(null, null);
        this.setToolTipText(I18n.tr((String)"Select Microsoft Streetside from the Imagery menu, then click on a blue vector bubble..", (Object[])new Object[0]));
    }

    private void initializeAndStartGUI() {
        threeSixtyDegreeViewerPanel = new ThreeSixtyDegreeViewerPanel();
        GraphicsUtils.PlatformHelper.run(() -> threeSixtyDegreeViewerPanel.initialize());
        this.add((Component)((Object)threeSixtyDegreeViewerPanel), "Center");
        this.revalidate();
        this.repaint();
        JPanel checkPanel = new JPanel();
        this.imgReloadAction = new ImageReloadAction(I18n.tr((String)"Reload", (Object[])new Object[0]));
        StreetsideButton imgReloadButton = new StreetsideButton(this.imgReloadAction);
        this.highResImageryCheck = new JCheckBox(I18n.tr((String)"High resolution", (Object[])new Object[0]));
        this.highResImageryCheck.setSelected(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get());
        this.highResImageryCheck.addActionListener(action -> StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.put(Boolean.valueOf(this.highResImageryCheck.isSelected())));
        StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.addListener(valueChange -> this.highResImageryCheck.setSelected(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()));
        checkPanel.add((Component)this.highResImageryCheck, "West");
        checkPanel.add((Component)imgReloadButton, "East");
        JPanel privacyLink = new JPanel();
        this.imgLinkAction = new WebLinkAction(I18n.tr((String)"Report a privacy concern with this image", (Object[])new Object[0]), null);
        privacyLink.add(new StreetsideButton(this.imgLinkAction, true));
        checkPanel.add((Component)privacyLink, "Last");
        this.add((Component)checkPanel, "First");
        this.add((Component)((Object)threeSixtyDegreeViewerPanel), "Center");
        this.add((Component)privacyLink, "Last");
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public synchronized void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        if (newImage != null) {
            String newImageId;
            Logging.debug((String)String.format("Selected Streetside image changed from %s to %s.", oldImage instanceof StreetsideImage ? ((StreetsideImage)oldImage).getId() : "\u2039none\u203a", newImage instanceof StreetsideImage ? ((StreetsideImage)newImage).getId() : "\u2039none\u203a"));
            String string = newImageId = newImage instanceof StreetsideImage ? ((StreetsideImage)newImage).getId() : null;
            if (newImageId != null) {
                String bubbleId = CubemapUtils.convertQuaternary2Decimal(newImageId);
                this.imageLinkChangeListener = b -> this.imgLinkAction.setURL(StreetsideURL.MainWebsite.streetsidePrivacyLink(bubbleId));
                this.imageLinkChangeListener.valueChanged(null);
                StreetsideProperties.CUBEMAP_LINK_TO_BLUR_EDITOR.addListener(this.imageLinkChangeListener);
            } else {
                if (this.imageLinkChangeListener != null) {
                    StreetsideProperties.CUBEMAP_LINK_TO_BLUR_EDITOR.removeListener(this.imageLinkChangeListener);
                    this.imageLinkChangeListener = null;
                }
                this.imgLinkAction.setURL(null);
            }
        }
    }

    public CubemapBox getCubemapBox() {
        return threeSixtyDegreeViewerPanel.getCubemapBox();
    }

    public static ThreeSixtyDegreeViewerPanel getThreeSixtyDegreeViewerPanel() {
        return threeSixtyDegreeViewerPanel;
    }
}

