/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsideLocationChangeset;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideSubmitCurrentChangesetAction;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideImageTreeCellRenderer;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideChangesetListener;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class StreetsideChangesetDialog
extends ToggleDialog
implements StreetsideChangesetListener {
    private static final long serialVersionUID = -3019715241209349372L;
    private static StreetsideChangesetDialog instance;
    private final DefaultTreeModel changesetTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private final Container rootComponent = new JPanel(new BorderLayout());
    private final SideButton submitButton = new SideButton((Action)((Object)new StreetsideSubmitCurrentChangesetAction(this)));
    private final JProgressBar uploadPendingProgress = new JProgressBar();

    public static void destroyInstance() {
        instance = null;
    }

    private StreetsideChangesetDialog() {
        super(I18n.tr((String)"Current Streetside changeset", (Object[])new Object[0]), "streetside-upload", I18n.tr((String)"Open Streetside changeset dialog", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Streetside changeset", (Object[])new Object[0]), (String)I18n.tr((String)"Open Streetside changeset dialog", (Object[])new Object[0]), (int)57, (int)5000), 200);
        this.createLayout(this.rootComponent, false, Collections.singletonList(this.submitButton));
        JTree changesetTree = new JTree(this.changesetTreeModel);
        changesetTree.expandRow(0);
        changesetTree.setShowsRootHandles(true);
        changesetTree.setRootVisible(false);
        changesetTree.setCellRenderer(new StreetsideImageTreeCellRenderer());
        changesetTree.getSelectionModel().setSelectionMode(1);
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add(this.spacer, GBC.eol());
        treesPanel.add((Component)changesetTree, GBC.eol().fill(2));
        treesPanel.add((Component)new JSeparator(), GBC.eol().fill(2));
        treesPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        this.rootComponent.add((Component)new JScrollPane(treesPanel), "Center");
        this.uploadPendingProgress.setIndeterminate(true);
        this.uploadPendingProgress.setString(I18n.tr((String)"Submitting changeset to server\u2026", (Object[])new Object[0]));
        this.uploadPendingProgress.setStringPainted(true);
        this.setUploadPending(false);
    }

    public static synchronized StreetsideChangesetDialog getInstance() {
        if (instance == null) {
            instance = new StreetsideChangesetDialog();
        }
        return instance;
    }

    private void buildTree() {
        StreetsideLocationChangeset changeset = StreetsideLayer.getInstance().getLocationChangeset();
        this.submitButton.setEnabled(!changeset.isEmpty());
        DefaultMutableTreeNode changesetRoot = new DefaultMutableTreeNode();
        changeset.parallelStream().filter(Objects::nonNull).forEach(img -> {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(img);
            changesetRoot.add(node);
        });
        this.spacer.setVisible(changeset.isEmpty());
        this.changesetTreeModel.setRoot(changesetRoot);
    }

    public void setUploadPending(boolean isUploadPending) {
        if (isUploadPending) {
            this.rootComponent.add((Component)this.uploadPendingProgress, "South");
        } else {
            this.rootComponent.remove(this.uploadPendingProgress);
        }
        this.submitButton.setEnabled(!isUploadPending && StreetsideLayer.hasInstance() && !StreetsideLayer.getInstance().getLocationChangeset().isEmpty());
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    @Override
    public void changesetChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::buildTree);
        } else {
            this.buildTree();
        }
    }
}

