/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.json.Json;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsideLocationChangeset;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideChangesetDialog;
import org.openstreetmap.josm.plugins.streetside.utils.PluginState;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.plugins.streetside.utils.api.JsonLocationChangesetEncoder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class StreetsideSubmitCurrentChangesetAction
extends JosmAction {
    private static final long serialVersionUID = 4995924098228082806L;
    private final StreetsideChangesetDialog changesetDialog;

    public StreetsideSubmitCurrentChangesetAction(StreetsideChangesetDialog changesetDialog) {
        super(I18n.tr((String)"Submit changeset", (Object[])new Object[0]), new ImageProvider("dialogs", "streetside-upload").setSize(ImageProvider.ImageSizes.DEFAULT), I18n.tr((String)"Submit the current changeset", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Submit changeset to Streetside", (String)I18n.tr((String)"Submit the current changeset to Streetside", (Object[])new Object[0]), (int)65535, (int)5000), false, "streetsideSubmitChangeset", false);
        this.changesetDialog = changesetDialog;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        new Thread(() -> {
            this.changesetDialog.setUploadPending(true);
            String token = StreetsideProperties.ACCESS_TOKEN.get();
            if (token != null && !token.trim().isEmpty()) {
                PluginState.setSubmittingChangeset(true);
                StreetsideUtils.updateHelpText();
                HttpClientBuilder builder = HttpClientBuilder.create();
                HttpPost httpPost = new HttpPost(StreetsideURL.APIv3.submitChangeset().toString());
                httpPost.addHeader("content-type", "application/json");
                httpPost.addHeader("Authorization", "Bearer " + token);
                StreetsideLocationChangeset locationChangeset = StreetsideLayer.getInstance().getLocationChangeset();
                String json = JsonLocationChangesetEncoder.encodeLocationChangeset(locationChangeset).build().toString();
                Logging.info((String)("Sending JSON to " + StreetsideURL.APIv3.submitChangeset() + "\n  " + json));
                try (CloseableHttpClient httpClient = builder.build();){
                    httpPost.setEntity((HttpEntity)new StringEntity(json));
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    Logging.debug((String)("HTTP request finished with response code " + response.getStatusLine().getStatusCode()));
                    if (response.getStatusLine().getStatusCode() == 201) {
                        String key = Json.createReader((InputStream)response.getEntity().getContent()).readObject().getString("key");
                        String state = Json.createReader((InputStream)response.getEntity().getContent()).readObject().getString("state");
                        I18n.marktr((String)"rejected");
                        I18n.marktr((String)"pending");
                        I18n.marktr((String)"approved");
                        String message = I18n.tr((String)"{0} images submitted, Changeset key: {1}, State: {2}", (Object[])new Object[]{locationChangeset.size(), key, state});
                        Logging.debug((String)message);
                        new Notification(message).setDuration(Notification.TIME_LONG).setIcon("rejected".equals(state) ? 0 : 1).show();
                        locationChangeset.cleanChangeset();
                    } else {
                        new Notification(I18n.tr((String)"Changeset upload failed with {0} error ''{1} {2}''!", (Object[])new Object[]{response.getStatusLine().getProtocolVersion(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()})).setIcon(0).setDuration(Notification.TIME_LONG).show();
                        Logging.error((String)("Failed response " + EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                }
                catch (IOException e) {
                    Logging.log((Level)Logging.LEVEL_ERROR, (String)"Exception while trying to submit a changeset to streetside.com", (Throwable)e);
                    new Notification(I18n.tr((String)"An exception occured while trying to submit a changeset. If this happens repeatedly, consider reporting a bug via the Help menu. If this message appears for the first time, simply try it again. This might have been an issue with the internet connection.", (Object[])new Object[0])).setDuration(Notification.TIME_LONG).setIcon(0).show();
                }
                finally {
                    PluginState.setSubmittingChangeset(false);
                }
            }
            this.changesetDialog.setUploadPending(false);
        }, "Streetside changeset upload").start();
    }
}

