/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class StreetsideCubemap
extends StreetsideAbstractImage
implements Comparable<StreetsideAbstractImage> {
    private static Map<String, Map<String, BufferedImage>> face2TilesMap = new HashMap<String, Map<String, BufferedImage>>();
    private static final float EPSILON = 1.0E-5f;

    public StreetsideCubemap(String quadId, LatLon latLon, double he) {
        super(quadId, latLon, he);
        face2TilesMap = new HashMap<String, Map<String, BufferedImage>>();
        EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> face2TilesMap.put(face.getValue(), new HashMap()));
    }

    public Map<String, Map<String, BufferedImage>> getFace2TilesMap() {
        return face2TilesMap;
    }

    @Override
    public int compareTo(StreetsideAbstractImage image) {
        if (image instanceof StreetsideImage) {
            return this.id.compareTo(((StreetsideImage)image).getId());
        }
        return this.hashCode() - image.hashCode();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void stopMoving() {
        super.stopMoving();
    }

    @Override
    public void turn(double he) {
        super.turn(he);
    }

    public int getHeight() {
        return StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 1016 : 510;
    }

    public void resetFaces2TileMap() {
        face2TilesMap = new HashMap<String, Map<String, BufferedImage>>();
        EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> face2TilesMap.put(face.getValue(), new HashMap()));
    }
}

