/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

public abstract class OverpassApi {
    public static final String union(String ... queries) {
        String result = "<union>\n";
        for (String query : queries) {
            if (query == null) continue;
            result = result + query + "\n";
        }
        result = result + "</union>";
        return result;
    }

    public static final String query(String bbox, OaQueryType type, String ... conditions) {
        String result = "<query type=\"" + (Object)((Object)type) + "\" >\n";
        if (bbox != null) {
            result = result + "<bbox-query " + bbox + "/>\n";
        }
        for (String condition : conditions) {
            if (condition == null) continue;
            result = result + condition + "\n";
        }
        result = result + "</query>";
        return result;
    }

    public static final String recurse(OaRecurseType type, String into) {
        return "<recurse type=\"" + (Object)((Object)type) + "\" into=\"" + into + "\"/>\n";
    }

    public static final String recurse(OaRecurseType ... types) {
        String result = "";
        for (OaRecurseType type : types) {
            result = result + "<recurse type=\"" + (Object)((Object)type) + "\"/>\n";
        }
        return result;
    }

    public static final String print() {
        return "<print mode=\"meta\"/>";
    }

    public static final String hasKey(String key) {
        return OverpassApi.hasKey(key, null);
    }

    public static final String hasKey(String key, String value) {
        return "<has-kv k=\"" + key + "\" " + (value != null && !value.isEmpty() ? "v=\"" + value + "\"" : "") + " />";
    }

    public static enum OaRecurseType {
        RELATION_RELATION("relation-relation"),
        RELATION_BACKWARDS("relation-backwards"),
        RELATION_WAY("relation-way"),
        RELATION_NODE("relation-node"),
        WAY_NODE("way-node"),
        WAY_RELATION("way-relation"),
        NODE_RELATION("node-relation"),
        NODE_WAY("node-way");

        private final String value;

        public String toString() {
            return this.value;
        }

        private OaRecurseType(String value) {
            this.value = value;
        }
    }

    public static enum OaQueryType {
        NODE("node"),
        WAY("way"),
        RELATION("relation");

        private final String value;

        public String toString() {
            return this.value;
        }

        private OaQueryType(String value) {
            this.value = value;
        }
    }
}

