/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.gui.ModulePreference;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleDownloadTask;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OdPreferenceSetting
extends DefaultTabPreferenceSetting {
    private final JTextField oapi = new JTextField();
    private final JTextField xapi = new JTextField();
    private final JCheckBox rawData = new JCheckBox(I18n.tr((String)"Raw data", (Object[])new Object[0]));
    public final JTabbedPane tabPane = new JTabbedPane();
    public JPanel masterPanel;
    private final ModulePreference modulePref = new ModulePreference();

    public OdPreferenceSetting() {
        super("o48.png", I18n.tr((String)"OpenData Preferences", (Object[])new Object[0]), I18n.tr((String)"A special handler for various Open Data portals<br/><br/>Please read the Terms and Conditions of Use of each portal<br/>before any upload of data loaded by this plugin.", (Object[])new Object[0]));
    }

    public static final Collection<String> getModuleSites() {
        return Main.pref.getList("opendata.modules.sites", Arrays.asList(OdConstants.DEFAULT_MODULE_SITES));
    }

    public static void setModuleSites(List<String> sites) {
        Main.pref.putList("opendata.modules.sites", sites);
    }

    public void addGui(PreferenceTabbedPane gui) {
        this.masterPanel = gui.createPreferenceTab((TabPreferenceSetting)this);
        this.modulePref.addGui(gui);
        this.tabPane.add(this.createGeneralSettings());
        JScrollPane scrollpane = new JScrollPane(this.tabPane);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.masterPanel.add((Component)scrollpane, GBC.eol().fill(1));
    }

    protected JPanel createGeneralSettings() {
        JPanel general = new JPanel(new GridBagLayout());
        general.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        general.setName(I18n.tr((String)"General settings", (Object[])new Object[0]));
        this.rawData.setSelected(Main.pref.getBoolean("opendata.rawdata", false));
        this.rawData.setToolTipText(I18n.tr((String)"Import only raw data (i.e. do not add/delete tags or replace them by standard OSM tags)", (Object[])new Object[0]));
        general.add((Component)this.rawData, GBC.eop().insets(0, 0, 0, 0));
        general.add((Component)new JSeparator(0), GBC.eol().fill(2));
        JLabel jLabelOapi = new JLabel(I18n.tr((String)"Overpass API server:", (Object[])new Object[0]));
        this.oapi.setText(Main.pref.get("opendata.oapi", "https://www.overpass-api.de/api/interpreter?"));
        this.oapi.setToolTipText(I18n.tr((String)"Overpass API server used to download OSM data", (Object[])new Object[0]));
        general.add((Component)jLabelOapi, GBC.std().insets(0, 5, 10, 0));
        general.add((Component)this.oapi, GBC.eol().fill(2).insets(5, 5, 200, 5));
        JLabel jLabelXapi = new JLabel(I18n.tr((String)"XAPI server:", (Object[])new Object[0]));
        this.xapi.setText(Main.pref.get("opendata.xapi", "https://www.overpass-api.de/api/xapi?"));
        this.xapi.setToolTipText(I18n.tr((String)"XAPI server used to download OSM data when Overpass API is not available", (Object[])new Object[0]));
        general.add((Component)jLabelXapi, GBC.std().insets(0, 5, 10, 0));
        general.add((Component)this.xapi, GBC.eol().fill(2).insets(5, 5, 200, 5));
        general.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        return general;
    }

    public boolean ok() {
        boolean result = this.modulePref.ok();
        Main.pref.put("opendata.oapi", this.oapi.getText());
        Main.pref.put("opendata.xapi", this.xapi.getText());
        Main.pref.putBoolean("opendata.rawdata", this.rawData.isSelected());
        List<ModuleInformation> toDownload = this.modulePref.getModulesScheduledForUpdateOrDownload();
        ModuleDownloadTask task = toDownload != null && !toDownload.isEmpty() ? new ModuleDownloadTask(this.masterPanel, toDownload, I18n.tr((String)"Download modules", (Object[])new Object[0])) : null;
        Runnable continuation = () -> {
            boolean requiresRestart = false;
            if (task != null && !task.isCanceled() && !task.getDownloadedModules().isEmpty()) {
                requiresRestart = true;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (task != null && !task.isCanceled()) {
                sb.append(ModulePreference.buildDownloadSummary(task));
            }
            if (requiresRestart) {
                sb.append(I18n.tr((String)"You have to restart JOSM for some settings to take effect.", (Object[])new Object[0]));
            }
            sb.append("</html>");
            if (task != null && !task.isCanceled() || requiresRestart) {
                JOptionPane.showMessageDialog(Main.parent, sb.toString(), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            }
            Main.parent.repaint();
        };
        if (task != null) {
            MainApplication.worker.submit((Runnable)((Object)task));
            MainApplication.worker.submit(() -> SwingUtilities.invokeLater(continuation));
        } else {
            continuation.run();
        }
        return task == null ? result : false;
    }
}

