/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.actions;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetUpdater;
import org.openstreetmap.josm.plugins.opendata.core.gui.AskLicenseAgreementDialog;
import org.openstreetmap.josm.plugins.opendata.core.io.NetworkReader;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.tools.I18n;

public class DownloadDataTask
extends DownloadOsmTask {
    private AbstractDataSetHandler handler;

    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new InternalDownloadTasK(settings, new NetworkReader(url, this.handler, true), progressMonitor);
        this.currentBounds = null;
        if (this.handler == null || !this.handler.hasLicenseToBeAccepted() || this.askLicenseAgreement(this.handler.getLicense())) {
            return MainApplication.worker.submit((Runnable)this.downloadTask);
        }
        return null;
    }

    public boolean acceptsUrl(String url) {
        this.handler = null;
        for (Module module : ModuleHandler.moduleList) {
            for (AbstractDataSetHandler handler : module.getNewlyInstanciatedHandlers()) {
                if (!handler.acceptsUrl(url)) continue;
                this.handler = handler;
                return true;
            }
        }
        for (String ext : NetworkReader.FILE_AND_ARCHIVE_READERS.keySet()) {
            if (!Pattern.compile(".*\\." + ext, 2).matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] getPatterns() {
        String pattern = "";
        for (String ext : NetworkReader.FILE_AND_ARCHIVE_READERS.keySet()) {
            if (!pattern.isEmpty()) {
                pattern = pattern + "|";
            }
            pattern = pattern + "." + ext;
        }
        return new String[]{".*(" + pattern + ")"};
    }

    public String getTitle() {
        return I18n.tr((String)"Download open data", (Object[])new Object[0]);
    }

    protected final boolean askLicenseAgreement(License license) {
        if (license == null || license.getURL() == null && license.getSummaryURL() == null) {
            return true;
        }
        try {
            return new AskLicenseAgreementDialog(license).showDialog().getValue() == 1;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"License URL not available: {0}", (Object[])new Object[]{license.toString()}));
            return false;
        }
    }

    protected class InternalDownloadTasK
    extends DownloadOsmTask.DownloadTask {
        public InternalDownloadTasK(DownloadParams settings, NetworkReader reader, ProgressMonitor progressMonitor) {
            super((DownloadOsmTask)DownloadDataTask.this, settings, (OsmServerReader)reader, progressMonitor);
        }

        protected OsmDataLayer createNewLayer(String layerName) {
            File associatedFile = ((NetworkReader)this.reader).getReadFile();
            String filename = ((NetworkReader)this.reader).getReadFileName();
            if (layerName == null || layerName.isEmpty()) {
                layerName = associatedFile != null ? associatedFile.getName() : (filename != null && !filename.isEmpty() ? filename : OsmDataLayer.createNewName());
            }
            DataSetUpdater.updateDataSet(this.dataSet, DownloadDataTask.this.handler, associatedFile);
            return new OdDataLayer(this.dataSet, layerName, associatedFile, DownloadDataTask.this.handler);
        }
    }
}

