/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Compression.LZ;

import java.io.IOException;
import java.io.OutputStream;

public class OutWindow {
    byte[] _buffer;
    byte[] _buffer2 = null;
    int _bufferPos2 = 0;
    int _pos;
    int _windowSize = 0;
    int _streamPos;
    OutputStream _stream;
    long _processedSize;

    public void Create(int windowSize) {
        boolean kMinBlockSize = true;
        if (windowSize < 1) {
            windowSize = 1;
        }
        if (this._buffer == null || this._windowSize != windowSize) {
            this._buffer = new byte[windowSize];
        }
        this._windowSize = windowSize;
        this._pos = 0;
        this._streamPos = 0;
    }

    public void SetStream(OutputStream stream) throws IOException {
        this.ReleaseStream();
        this._stream = stream;
    }

    public void ReleaseStream() throws IOException {
        this.Flush();
        this._stream = null;
    }

    public void SetMemStream(byte[] d) {
        this._buffer2 = d;
        this._bufferPos2 = 0;
    }

    public void Init() {
        this.Init(false);
    }

    public void Init(boolean solid) {
        this._processedSize = 0L;
        if (!solid) {
            this._streamPos = 0;
            this._pos = 0;
        }
    }

    public void Flush() throws IOException {
        int size = this._pos - this._streamPos;
        if (size == 0) {
            return;
        }
        if (this._stream != null) {
            this._stream.write(this._buffer, this._streamPos, size);
        }
        if (this._buffer2 != null) {
            System.arraycopy(this._buffer, this._streamPos, this._buffer2, this._bufferPos2, size);
            this._bufferPos2 += size;
        }
        if (this._pos >= this._windowSize) {
            this._pos = 0;
        }
        this._streamPos = this._pos;
    }

    public void CopyBlock(int distance, int len) throws IOException {
        int pos = this._pos - distance - 1;
        if (pos < 0) {
            pos += this._windowSize;
        }
        while (len != 0) {
            if (pos >= this._windowSize) {
                pos = 0;
            }
            this._buffer[this._pos++] = this._buffer[pos++];
            ++this._processedSize;
            if (this._pos >= this._windowSize) {
                this.Flush();
            }
            --len;
        }
    }

    public void PutByte(byte b) throws IOException {
        this._buffer[this._pos++] = b;
        ++this._processedSize;
        if (this._pos >= this._windowSize) {
            this.Flush();
        }
    }

    public void WriteByte(int b) throws IOException {
        this._buffer[this._pos++] = (byte)b;
        ++this._processedSize;
        if (this._pos >= this._windowSize) {
            this.Flush();
        }
    }

    public byte GetByte(int distance) {
        int pos = this._pos - distance - 1;
        if (pos < 0) {
            pos += this._windowSize;
        }
        return this._buffer[pos];
    }

    public long GetProcessedSize() {
        return this._processedSize;
    }
}

