/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.mode;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.util.Calendar;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideDownloader;

public abstract class AbstractMode
extends MouseAdapter
implements NavigatableComponent.ZoomChangeListener {
    private static final int DOWNLOAD_COOLDOWN = 2000;
    private static SemiautomaticThread semiautomaticThread = new SemiautomaticThread();
    public int cursor = 0;

    protected StreetsideAbstractImage getClosest(Point clickPoint) {
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        StreetsideAbstractImage closest = null;
        for (StreetsideAbstractImage image : StreetsideLayer.getInstance().getData().getImages()) {
            Point imagePoint = MainApplication.getMap().mapView.getPoint(image.getMovingLatLon());
            imagePoint.setLocation(imagePoint.getX(), imagePoint.getY());
            double dist = clickPoint.distanceSq(imagePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(imagePoint) < snapDistance) || !image.isVisible()) continue;
            minDistance = dist;
            closest = image;
        }
        return closest;
    }

    public abstract void paint(Graphics2D var1, MapView var2, Bounds var3);

    public void zoomChanged() {
        if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.VISIBLE_AREA) {
            if (!semiautomaticThread.isAlive()) {
                semiautomaticThread.start();
            }
            semiautomaticThread.moved();
        }
    }

    public static void resetThread() {
        semiautomaticThread.interrupt();
        semiautomaticThread = new SemiautomaticThread();
    }

    private static class SemiautomaticThread
    extends Thread {
        private long lastDownload;
        private boolean moved;

        private SemiautomaticThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (this.moved && Calendar.getInstance().getTimeInMillis() - this.lastDownload >= 2000L) {
                    this.lastDownload = Calendar.getInstance().getTimeInMillis();
                    StreetsideDownloader.downloadVisibleArea();
                    this.moved = false;
                    StreetsideLayer.invalidateInstance();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void moved() {
            this.moved = true;
        }
    }
}

