/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.image.BufferedImage;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.NonInvertibleTransformException;
import org.openstreetmap.josm.plugins.streetside.cubemap.CameraTransformer;
import org.openstreetmap.josm.plugins.streetside.cubemap.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.utils.CubemapBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ThreeSixtyDegreeViewerPanel
extends JFXPanel {
    private static final long serialVersionUID = -4940350009018422000L;
    private static Group root;
    private static Group subGroup;
    private static CubemapBox cubemapBox;
    private static PerspectiveCamera camera;
    private static CameraTransformer cameraTransform;
    private static double mousePosX;
    private static double mousePosY;
    private static double mouseOldX;
    private static double mouseOldY;
    private static double mouseDeltaX;
    private static double mouseDeltaY;
    private static double cameraDistance;
    private static Image front;
    private static Image right;
    private static Image back;
    private static Image left;
    private static Image up;
    private static Image down;

    void initialize() {
        root = new Group();
        camera = new PerspectiveCamera(true);
        cameraTransform.setTranslate(0.0, 0.0, 0.0);
        cameraTransform.getChildren().addAll((Object[])new Node[]{camera});
        camera.setNearClip(0.1);
        camera.setFarClip(1000000.0);
        camera.setFieldOfView(42.0);
        camera.setTranslateZ(-cameraDistance);
        PointLight light = new PointLight(Color.WHITE);
        cameraTransform.getChildren().add((Object)light);
        light.setTranslateX(camera.getTranslateX());
        light.setTranslateY(camera.getTranslateY());
        light.setTranslateZ(camera.getTranslateZ());
        root.getChildren().add((Object)cameraTransform);
        double size = 100000.0;
        cubemapBox = new CubemapBox(front, right, back, left, up, down, 100000.0, camera);
        subGroup = new Group();
        subGroup.getChildren().add((Object)cameraTransform);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ThreeSixtyDegreeViewerPanel.this.setScene(ThreeSixtyDegreeViewerPanel.createScene());
                }
                catch (NonInvertibleTransformException e) {
                    Logging.error((String)I18n.tr((String)"Error initializing StreetsideViewerPanel - JavaFX {0}", (Object[])new Object[]{e.getMessage()}));
                }
            }
        });
    }

    private static Scene createScene() throws NonInvertibleTransformException {
        Scene scene = new Scene((Parent)new Group(new Node[]{root}), 1024.0, 668.0, true, SceneAntialiasing.BALANCED);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.setCamera((Camera)camera);
        scene.setOnKeyPressed(event -> {
            KeyCode keycode;
            double change = 10.0;
            if (event.isShiftDown()) {
                change = 50.0;
            }
            if ((keycode = event.getCode()) == KeyCode.W) {
                camera.setTranslateZ(camera.getTranslateZ() + change);
            }
            if (keycode == KeyCode.S) {
                camera.setTranslateZ(camera.getTranslateZ() - change);
            }
            if (keycode == KeyCode.A) {
                camera.setTranslateX(camera.getTranslateX() - change);
            }
            if (keycode == KeyCode.D) {
                camera.setTranslateX(camera.getTranslateX() + change);
            }
        });
        scene.setOnMousePressed(me -> {
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseOldX = me.getSceneX();
            mouseOldY = me.getSceneY();
        });
        scene.setOnMouseDragged(me -> {
            mouseOldX = mousePosX;
            mouseOldY = mousePosY;
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseDeltaX = mousePosX - mouseOldX;
            mouseDeltaY = mousePosY - mouseOldY;
            double modifier = 10.0;
            double modifierFactor = 0.1;
            if (me.isControlDown()) {
                modifier = 0.1;
            }
            if (me.isShiftDown()) {
                modifier = 50.0;
            }
            if (me.isPrimaryButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.ry.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.ry.getAngle() + mouseDeltaX * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
                ThreeSixtyDegreeViewerPanel.cameraTransform.rx.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.rx.getAngle() - mouseDeltaY * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
            } else if (me.isSecondaryButtonDown()) {
                double z = camera.getTranslateZ();
                double newZ = z + mouseDeltaX * 0.1 * modifier;
                camera.setTranslateZ(newZ);
            } else if (me.isMiddleButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setX(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getX() + mouseDeltaX * 0.1 * modifier * 0.3);
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setY(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getY() + mouseDeltaY * 0.1 * modifier * 0.3);
            }
        });
        root.getChildren().addAll((Object[])new Node[]{cubemapBox, subGroup});
        root.setAutoSizeChildren(true);
        subGroup.setAutoSizeChildren(true);
        Platform.setImplicitExit((boolean)false);
        return scene;
    }

    private static Scene createDefaultScene() {
        double size = 100000.0;
        TextArea textArea = new TextArea();
        textArea.setText("No Streetside image selected.");
        VBox vbox = new VBox(new Node[]{textArea});
        Scene scene = new Scene((Parent)vbox, 200.0, 100.0);
        return scene;
    }

    public static Scene createScene(BufferedImage img0, BufferedImage img1, BufferedImage img2, BufferedImage img3, BufferedImage img4, BufferedImage img5) throws NonInvertibleTransformException {
        front = GraphicsUtils.convertBufferedImage2JavaFXImage(img0);
        right = GraphicsUtils.convertBufferedImage2JavaFXImage(img1);
        back = GraphicsUtils.convertBufferedImage2JavaFXImage(img2);
        left = GraphicsUtils.convertBufferedImage2JavaFXImage(img3);
        up = GraphicsUtils.convertBufferedImage2JavaFXImage(img4);
        down = GraphicsUtils.convertBufferedImage2JavaFXImage(img5);
        root = new Group();
        camera = new PerspectiveCamera(true);
        cameraTransform.setTranslate(0.0, 0.0, 0.0);
        cameraTransform.getChildren().addAll((Object[])new Node[]{camera});
        camera.setNearClip(0.1);
        camera.setFarClip(1000000.0);
        camera.setFieldOfView(42.0);
        camera.setTranslateZ(-cameraDistance);
        PointLight light = new PointLight(Color.WHITE);
        cameraTransform.getChildren().add((Object)light);
        light.setTranslateX(camera.getTranslateX());
        light.setTranslateY(camera.getTranslateY());
        light.setTranslateZ(camera.getTranslateZ());
        root.getChildren().add((Object)cameraTransform);
        double size = 100000.0;
        cubemapBox = new CubemapBox(front, right, back, left, up, down, 100000.0, camera);
        Group torusGroup = new Group();
        torusGroup.getChildren().add((Object)cameraTransform);
        Scene scene = new Scene((Parent)new Group(new Node[]{root}), 1024.0, 668.0, true, SceneAntialiasing.BALANCED);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.setCamera((Camera)camera);
        scene.setOnKeyPressed(event -> {
            KeyCode keycode;
            double change = 10.0;
            if (event.isShiftDown()) {
                change = 50.0;
            }
            if ((keycode = event.getCode()) == KeyCode.W) {
                camera.setTranslateZ(camera.getTranslateZ() + change);
            }
            if (keycode == KeyCode.S) {
                camera.setTranslateZ(camera.getTranslateZ() - change);
            }
            if (keycode == KeyCode.A) {
                camera.setTranslateX(camera.getTranslateX() - change);
            }
            if (keycode == KeyCode.D) {
                camera.setTranslateX(camera.getTranslateX() + change);
            }
        });
        scene.setOnMousePressed(me -> {
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseOldX = me.getSceneX();
            mouseOldY = me.getSceneY();
        });
        scene.setOnMouseDragged(me -> {
            mouseOldX = mousePosX;
            mouseOldY = mousePosY;
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseDeltaX = mousePosX - mouseOldX;
            mouseDeltaY = mousePosY - mouseOldY;
            double modifier = 10.0;
            double modifierFactor = 0.1;
            if (me.isControlDown()) {
                modifier = 0.1;
            }
            if (me.isShiftDown()) {
                modifier = 50.0;
            }
            if (me.isPrimaryButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.ry.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.ry.getAngle() + mouseDeltaX * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
                ThreeSixtyDegreeViewerPanel.cameraTransform.rx.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.rx.getAngle() - mouseDeltaY * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
            } else if (me.isSecondaryButtonDown()) {
                double z = camera.getTranslateZ();
                double newZ = z + mouseDeltaX * 0.1 * modifier;
                camera.setTranslateZ(newZ);
            } else if (me.isMiddleButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setX(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getX() + mouseDeltaX * 0.1 * modifier * 0.3);
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setY(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getY() + mouseDeltaY * 0.1 * modifier * 0.3);
            }
        });
        root.getChildren().addAll((Object[])new Node[]{cubemapBox, torusGroup});
        root.setAutoSizeChildren(true);
        return scene;
    }

    public CubemapBox getCubemapBox() {
        if (cubemapBox == null) {
            this.initialize();
        }
        return cubemapBox;
    }

    static {
        cameraTransform = new CameraTransformer();
        cameraDistance = 5000.0;
    }
}

