/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.SelectableLabel;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoPanel;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class StreetsideViewerHelpPopup
extends JPopupMenu {
    private static final long serialVersionUID = -7840242522398163839L;
    private final Component invokerComp;
    private boolean alreadyDisplayed;

    public StreetsideViewerHelpPopup(Component invoker) {
        this.invokerComp = invoker;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel topBar = new JPanel();
        topBar.add(new JLabel(ImageProvider.get((String)"streetside-logo-white")));
        topBar.setBackground(StreetsideColorScheme.TOOLBAR_DARK_GREY);
        this.add((Component)topBar, "North");
        JTextPane mainText = new JTextPane();
        mainText.setContentType("text/html");
        mainText.setFont(SelectableLabel.DEFAULT_FONT);
        mainText.setText("<html><div style='width:250px'>" + I18n.tr((String)"The Streetside plugin now uses a separate panel to display extra information (like the image key) and actions for the currently selected Streetside image (like viewing it in a browser).", (Object[])new Object[0]) + "<br><br>" + I18n.tr((String)"It can be activated by clicking the left button at the bottom of this message or the button in the toolbar on the left, which uses the same icon.", (Object[])new Object[0]) + "</div></html>");
        this.add((Component)mainText, "Center");
        JPanel bottomBar = new JPanel();
        bottomBar.setBackground(new Color(0xFFFFFF, true));
        StreetsideButton infoButton = new StreetsideButton(ImageInfoPanel.getInstance().getToggleAction());
        infoButton.addActionListener(e -> this.setVisible(false));
        bottomBar.add(infoButton);
        StreetsideButton closeBtn = new StreetsideButton(new AbstractAction(){
            private static final long serialVersionUID = -6193886964751195196L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StreetsideViewerHelpPopup.this.setVisible(false);
                StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(0));
            }
        });
        closeBtn.setText(I18n.tr((String)"I got it, close this.", (Object[])new Object[0]));
        bottomBar.add(closeBtn);
        this.add((Component)bottomBar, "South");
        this.setBackground(Color.WHITE);
    }

    public boolean showPopup() {
        if (!this.alreadyDisplayed && this.invokerComp.isShowing()) {
            try {
                this.show(this.invokerComp, this.invokerComp.getWidth(), 0);
                this.alreadyDisplayed = true;
                return true;
            }
            catch (IllegalComponentStateException e) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"Could not show ImageInfoHelpPopup, because probably the invoker component has disappeared from screen.", (Throwable)e);
            }
        }
        return false;
    }
}

