/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;

public class StreetsideImportedImage
extends StreetsideAbstractImage {
    protected File file;

    public StreetsideImportedImage(String id, LatLon latLon, double ca, File file) {
        this(id, latLon, ca, file, Calendar.getInstance().getTimeInMillis());
    }

    public StreetsideImportedImage(String id, LatLon latLon, double ca, File file, String datetimeOriginal) {
        this(id, latLon, ca, file, StreetsideImportedImage.parseTimestampElseCurrentTime(datetimeOriginal));
    }

    public static StreetsideImportedImage createInstance(ImageEntry geoImage) {
        double ca;
        LatLon coord;
        if (geoImage == null) {
            return null;
        }
        if (geoImage.getFile() == null) {
            throw new IllegalArgumentException("Can't create an imported image from an ImageEntry without associated file.");
        }
        CachedLatLon cachedCoord = geoImage.getPos();
        LatLon latLon = coord = cachedCoord == null ? null : cachedCoord.getRoundedToOsmPrecision();
        if (coord == null) {
            MapView mv = StreetsidePlugin.getMapView();
            coord = mv == null ? new LatLon(0.0, 0.0) : mv.getProjection().eastNorth2latlon(mv.getCenter());
        }
        double d = ca = geoImage.getExifImgDir() == null ? 0.0 : geoImage.getExifImgDir();
        long time = geoImage.hasGpsTime() ? geoImage.getGpsTime().getTime() : (geoImage.hasExifTime() ? geoImage.getExifTime().getTime() : System.currentTimeMillis());
        return new StreetsideImportedImage("00000000", coord, ca, geoImage.getFile(), time);
    }

    private static long parseTimestampElseCurrentTime(String timestamp) {
        try {
            return StreetsideUtils.getEpoch(timestamp, "yyyy:MM:dd HH:mm:ss");
        }
        catch (ParseException e) {
            try {
                return StreetsideUtils.getEpoch(timestamp, "yyyy/MM/dd HH:mm:ss");
            }
            catch (ParseException e1) {
                return StreetsideUtils.currentTime();
            }
        }
    }

    public StreetsideImportedImage(String id, LatLon latLon, double he, File file, long ca) {
        super(id, latLon, he);
        this.file = file;
        this.cd = ca;
    }

    public BufferedImage getImage() throws IOException {
        if (this.file != null) {
            return ImageIO.read(this.file);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int compareTo(StreetsideAbstractImage image) {
        if (image instanceof StreetsideImportedImage) {
            return this.file.compareTo(((StreetsideImportedImage)image).getFile());
        }
        return this.hashCode() - image.hashCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreetsideImportedImage)) {
            return false;
        }
        StreetsideImportedImage other = (StreetsideImportedImage)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }
}

