/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils.api;

import java.lang.reflect.Array;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideSequence;
import org.openstreetmap.josm.plugins.streetside.utils.api.JsonDecoder;

public final class JsonStreetsideSequencesDecoder {
    private JsonStreetsideSequencesDecoder() {
    }

    public static StreetsideSequence decodeSequence(JsonObject json) {
        Long ca;
        if (json == null || !"Feature".equals(json.getString("type", null))) {
            return null;
        }
        StreetsideSequence result = null;
        JsonObject properties = json.getJsonObject("properties");
        Long l = ca = properties == null ? null : JsonDecoder.decodeTimestamp(properties.getString("cd", null));
        if (properties != null && properties.getString("id", null) != null && ca != null) {
            result = new StreetsideSequence(properties.getString("id", null), ca);
            Double[] cas = JsonStreetsideSequencesDecoder.decodeCoordinateProperty(properties, "hes", val -> val instanceof JsonNumber ? Double.valueOf(((JsonNumber)val).doubleValue()) : null, Double.class);
            String[] imageIds = JsonStreetsideSequencesDecoder.decodeCoordinateProperty(properties, "image_ids", val -> val instanceof JsonString ? ((JsonString)val).getString() : null, String.class);
            LatLon[] geometry = JsonStreetsideSequencesDecoder.decodeLatLons(json.getJsonObject("geometry"));
            int sequenceLength = Math.min(Math.min(cas.length, imageIds.length), geometry.length);
            for (int i = 0; i < sequenceLength; ++i) {
                if (cas[i] == null || imageIds[i] == null || geometry[i] == null) continue;
                StreetsideImage img = new StreetsideImage(imageIds[i], geometry[i], (double)cas[i]);
                result.add(img);
            }
            if (result.getImages().isEmpty()) {
                result = null;
            }
        }
        return result;
    }

    public static StreetsideImage decodeBubbleData(StreetsideImage image) {
        if (image == null) {
            return null;
        }
        StreetsideImage result = null;
        if (image.getId() != null) {
            result = new StreetsideImage(image.getId(), new LatLon(image.getLa(), image.getLo()), 0.0);
            result.setAl(image.getAl());
            result.setRo(image.getRo());
            result.setPi(image.getPi());
            result.setHe(image.getHe());
            result.setBl(image.getBl());
            result.setMl(image.getMl());
            result.setNe(image.getNe());
            result.setPr(image.getPr());
            result.setNbn(image.getNbn());
            result.setPbn(image.getPbn());
            result.setRn(image.getRn());
            result.setCd(image.getCd());
        }
        return result;
    }

    public static StreetsideSequence decodeStreetsideSequence(JsonObject json) {
        if (json == null) {
            return null;
        }
        StreetsideSequence result = null;
        if (json.getString("id", null) != null && json.getString("la", null) != null && json.getString("lo", null) != null) {
            result = new StreetsideSequence(json.getString("id", null), json.getJsonNumber("la").doubleValue(), json.getJsonNumber("lo").doubleValue(), json.getJsonNumber("cd").longValue());
        }
        return result;
    }

    private static <T> T[] decodeJsonArray(JsonArray array, Function<JsonValue, T> decodeValueFunction, Class<T> clazz) {
        Object[] result;
        if (array == null) {
            result = (Object[])Array.newInstance(clazz, 0);
        } else {
            result = (Object[])Array.newInstance(clazz, array.size());
            for (int i = 0; i < result.length; ++i) {
                result[i] = decodeValueFunction.apply((JsonValue)array.get(i));
            }
        }
        return result;
    }

    private static <T> T[] decodeCoordinateProperty(JsonObject json, String key, Function<JsonValue, T> decodeValueFunction, Class<T> clazz) {
        JsonValue valueArray;
        JsonValue coordinateProperties;
        JsonValue jsonValue = coordinateProperties = json == null ? null : (JsonValue)json.get((Object)"coordinateProperties");
        if (coordinateProperties instanceof JsonObject && (valueArray = (JsonValue)((JsonObject)coordinateProperties).get((Object)key)) instanceof JsonArray) {
            return JsonStreetsideSequencesDecoder.decodeJsonArray((JsonArray)valueArray, decodeValueFunction, clazz);
        }
        return (Object[])Array.newInstance(clazz, 0);
    }

    private static LatLon[] decodeLatLons(JsonObject json) {
        JsonValue coords;
        JsonValue jsonValue = coords = json == null ? null : (JsonValue)json.get((Object)"coordinates");
        if (coords instanceof JsonArray && "LineString".equals(json.getString("type", null))) {
            LatLon[] result = new LatLon[((JsonArray)coords).size()];
            for (int i = 0; i < ((JsonArray)coords).size(); ++i) {
                JsonValue coord = (JsonValue)((JsonArray)coords).get(i);
                if (!(coord instanceof JsonArray)) continue;
                result[i] = JsonDecoder.decodeLatLon((JsonArray)coord);
            }
            return result;
        }
        return new LatLon[0];
    }
}

