/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils.api;

import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.streetside.model.ImageDetection;
import org.openstreetmap.josm.plugins.streetside.utils.api.JsonDecoder;
import org.openstreetmap.josm.tools.Logging;

public final class JsonImageDetectionDecoder {
    private JsonImageDetectionDecoder() {
    }

    public static ImageDetection decodeImageDetection(JsonObject json) {
        if (json == null || !"Feature".equals(json.getString("type", null))) {
            return null;
        }
        JsonValue properties = (JsonValue)json.get((Object)"properties");
        if (properties instanceof JsonObject) {
            String key = ((JsonObject)properties).getString("key", null);
            String packag = ((JsonObject)properties).getString("package", null);
            String imageKey = ((JsonObject)properties).getString("image_key", null);
            String value = ((JsonObject)properties).getString("value", null);
            JsonValue scoreVal = (JsonValue)((JsonObject)properties).get((Object)"score");
            Double score = scoreVal instanceof JsonNumber ? Double.valueOf(((JsonNumber)scoreVal).doubleValue()) : null;
            Shape shape = JsonImageDetectionDecoder.decodeShape((JsonValue)((JsonObject)properties).get((Object)"shape"));
            if (shape instanceof Path2D && imageKey != null && key != null && score != null && packag != null && value != null) {
                return new ImageDetection((Path2D)shape, imageKey, key, score, packag, value);
            }
        }
        return null;
    }

    private static Shape decodeShape(JsonValue json) {
        if (json instanceof JsonObject) {
            if (!"Polygon".equals(((JsonObject)json).getString("type", null))) {
                Logging.warn((String)String.format("Image detections using shapes with type=%s are currently not supported!", ((JsonObject)json).getString("type", "\u2039no type set\u203a")));
            } else {
                JsonValue coordinates = (JsonValue)((JsonObject)json).get((Object)"coordinates");
                if (coordinates instanceof JsonArray && !((JsonArray)coordinates).isEmpty()) {
                    return JsonImageDetectionDecoder.decodePolygon((JsonArray)coordinates);
                }
            }
        }
        return null;
    }

    private static Path2D decodePolygon(JsonArray json) {
        Path2D.Double shape = new Path2D.Double();
        json.forEach(val -> {
            Path2D part;
            Path2D path2D = part = val instanceof JsonArray ? JsonImageDetectionDecoder.decodeSimplePolygon((JsonArray)val) : null;
            if (part != null) {
                shape.append(part, false);
            }
        });
        if (shape.getCurrentPoint() != null) {
            return shape;
        }
        return null;
    }

    private static Path2D decodeSimplePolygon(JsonArray json) {
        Path2D.Double shape = new Path2D.Double();
        json.forEach(val -> {
            double[] coord = JsonDecoder.decodeDoublePair(val instanceof JsonArray ? (JsonArray)val : null);
            if (shape.getCurrentPoint() == null && coord != null) {
                shape.moveTo(coord[0], coord[1]);
            } else if (coord != null) {
                shape.lineTo(coord[0], coord[1]);
            }
        });
        if (shape.getCurrentPoint() != null) {
            shape.closePath();
            return shape;
        }
        return null;
    }
}

