/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideURL {
    private static final String STREETSIDE_BASE_URL = "https://dev.virtualearth.net/mapcontrol/HumanScaleServices/GetBubbles.ashx";
    private static final String BASE_API_V2_URL = "https://a.mapillary.com/v2/";
    private static final String CLIENT_ID = "T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz";
    private static final String BING_MAPS_KEY = "AuftgJsO0Xs8Ts4M1xZUQJQXJNsvmh3IV8DkNieCiy3tCwCUMq76-WpkrBtNAuEm";
    private static final String TEST_BUBBLE_ID = "80848005";
    private static final String STREETSIDE_PRIVACY_URL = "https://www.bing.com/maps/privacyreport/streetsideprivacyreport?bubbleid=";
    private static final int OSM_BBOX_NORTH = 3;
    private static final int OSM_BBOX_SOUTH = 1;
    private static final int OSM_BBOXEAST = 2;
    private static final int OSM_BBOX_WEST = 0;

    private StreetsideURL() {
    }

    public static URL[] string2URLs(String baseUrlPrefix, String cubemapImageId, String baseUrlSuffix) {
        ArrayList res = new ArrayList();
        switch (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 16 : 4) {
            case 16: {
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            try {
                                String urlStr = baseUrlPrefix + cubemapImageId + CubemapUtils.rowCol2StreetsideCellAddressMap.get(String.valueOf(i) + String.valueOf(j)) + baseUrlSuffix;
                                res.add(new URL(urlStr));
                                continue;
                            }
                            catch (MalformedURLException e) {
                                Logging.error((String)I18n.tr((String)"Error creating URL String for cubemap {0}", (Object[])new Object[]{cubemapImageId}));
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            case 4: {
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    for (int i = 0; i < 4; ++i) {
                        try {
                            String urlStr = baseUrlPrefix + cubemapImageId + CubemapUtils.rowCol2StreetsideCellAddressMap.get(String.valueOf(i)) + baseUrlSuffix;
                            res.add(new URL(urlStr));
                            continue;
                        }
                        catch (MalformedURLException e) {
                            Logging.error((String)I18n.tr((String)"Error creating URL String for cubemap {0}", (Object[])new Object[]{cubemapImageId}));
                            e.printStackTrace();
                        }
                    }
                });
                break;
            }
        }
        return (URL[])res.stream().toArray(URL[]::new);
    }

    public static URL uploadSecretsURL() {
        return StreetsideURL.string2URL(BASE_API_V2_URL, "me/uploads/secrets", StreetsideURL.queryString(null));
    }

    static String queryString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?client_id=").append(CLIENT_ID);
        if (parts != null) {
            for (Map.Entry<String, String> entry : parts.entrySet()) {
                try {
                    ret.append('&').append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    Logging.error((Throwable)e);
                }
            }
        }
        return ret.toString();
    }

    static String queryStreetsideBoundsString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?n=");
        if (parts != null) {
            ArrayList<String> bbox = new ArrayList<String>(Arrays.asList(parts.get("bbox").split(",")));
            try {
                ret.append(URLEncoder.encode((String)bbox.get(3), StandardCharsets.UTF_8.name())).append("&s=").append(URLEncoder.encode((String)bbox.get(1), StandardCharsets.UTF_8.name())).append("&e=").append(URLEncoder.encode((String)bbox.get(2), StandardCharsets.UTF_8.name())).append("&w=").append(URLEncoder.encode((String)bbox.get(0), StandardCharsets.UTF_8.name())).append("&c=1000").append("&appkey=").append(BING_MAPS_KEY);
            }
            catch (UnsupportedEncodingException e) {
                Logging.error((Throwable)e);
            }
        }
        return ret.toString();
    }

    static String queryByIdString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?id=");
        try {
            ret.append(URLEncoder.encode(TEST_BUBBLE_ID, StandardCharsets.UTF_8.name()));
            ret.append('&').append(URLEncoder.encode("appkey=", StandardCharsets.UTF_8.name())).append('=').append(URLEncoder.encode(BING_MAPS_KEY, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            Logging.error((Throwable)e);
        }
        return ret.toString();
    }

    static URL string2URL(String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; strings != null && i < strings.length; ++i) {
            builder.append(strings[i]);
        }
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)String.format("The class '%s' produces malformed URLs like '%s'!", StreetsideURL.class.getName(), builder), (Throwable)e);
            return null;
        }
    }

    public static final class MainWebsite {
        private static final String BASE_URL = "https://www.mapillary.com/";

        private MainWebsite() {
        }

        public static URL browseImage(String id) {
            if (id == null) {
                throw new IllegalArgumentException("The image key must not be null!");
            }
            return StreetsideURL.string2URL("https://t.ssl.ak.tiles.virtualearth.net/tiles/hs" + id + ".jpg?g=6338&n=z");
        }

        public static URL blurEditImage(String key) {
            String urlEncodedKey;
            if (key == null) {
                throw new IllegalArgumentException("The image key must not be null!");
            }
            try {
                urlEncodedKey = URLEncoder.encode(key, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                Logging.log((Level)Logging.LEVEL_ERROR, (String)"Unsupported encoding when URL encoding", (Throwable)e);
                urlEncodedKey = key;
            }
            return StreetsideURL.string2URL(BASE_URL, "app/blur?focus=photo&pKey=", urlEncodedKey);
        }

        public static URL streetsidePrivacyLink(String id) {
            String urlEncodedId;
            if (id == null) {
                throw new IllegalArgumentException("The image id must not be null!");
            }
            try {
                urlEncodedId = URLEncoder.encode(id, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                Logging.log((Level)Logging.LEVEL_ERROR, (String)"Unsupported encoding when URL encoding", (Throwable)e);
                urlEncodedId = id;
            }
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_PRIVACY_URL, urlEncodedId);
        }

        public static URL connect(String redirectURI) {
            HashMap<String, String> parts = new HashMap<String, String>();
            if (redirectURI != null && redirectURI.length() >= 1) {
                parts.put("redirect_uri", redirectURI);
            }
            parts.put("response_type", "token");
            parts.put("scope", "user:read public:upload public:write");
            return StreetsideURL.string2URL(BASE_URL, "connect", StreetsideURL.queryString(parts));
        }

        public static URL mapObjectIcon(String key) {
            return StreetsideURL.string2URL(BASE_URL, "developer/api-documentation/images/traffic_sign/" + key + ".png");
        }
    }

    public static final class VirtualEarth {
        private static final String BASE_URL_PREFIX = "https://t.ssl.ak.tiles.virtualearth.net/tiles/hs";
        private static final String BASE_URL_SUFFIX = ".jpg?g=6338&n=z";

        private VirtualEarth() {
        }

        public static URL streetsideTile(String id, boolean thumbnail) {
            if (thumbnail) {
                id = id + "01";
            }
            URL url = StreetsideURL.string2URL(BASE_URL_PREFIX + id + BASE_URL_SUFFIX);
            Logging.info((String)"Tile task URL {0} invoked.", (Object[])new Object[]{url.toString()});
            return url;
        }
    }

    public static final class APIv3 {
        private static final String BASE_URL = "https://a.mapillary.com/v3/";

        private APIv3() {
        }

        public static URL getUser(String key) {
            return StreetsideURL.string2URL(BASE_URL, "users/", key, StreetsideURL.queryString(null));
        }

        public static URL submitChangeset() {
            return StreetsideURL.string2URL(BASE_URL, "changesets", APIv3.queryString(null));
        }

        public static URL searchDetections(Bounds bounds) {
            return StreetsideURL.string2URL(BASE_URL, "detections", APIv3.queryString(bounds));
        }

        public static URL searchImages(Bounds bounds) {
            return StreetsideURL.string2URL(BASE_URL, "images", APIv3.queryStreetsideString(bounds));
        }

        public static URL searchStreetsideImages(Bounds bounds) {
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_BASE_URL, APIv3.queryStreetsideString(bounds));
        }

        public static URL searchMapObjects(Bounds bounds) {
            return StreetsideURL.string2URL(BASE_URL, "objects", APIv3.queryString(bounds));
        }

        public static URL searchStreetsideSequences(Bounds bounds) {
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_BASE_URL, APIv3.queryStreetsideString(bounds));
        }

        public static URL parseNextFromLinkHeaderValue(String value) {
            if (value != null) {
                for (String link : value.split(",", Integer.MAX_VALUE)) {
                    boolean isNext = false;
                    URL url = null;
                    for (String linkPart : link.split(";", Integer.MAX_VALUE)) {
                        linkPart = linkPart.trim();
                        isNext |= linkPart.matches("rel\\s*=\\s*\"next\"");
                        if (linkPart.length() < 1 || linkPart.charAt(0) != '<' || !linkPart.endsWith(">")) continue;
                        try {
                            url = new URL(linkPart.substring(1, linkPart.length() - 1));
                        }
                        catch (MalformedURLException e) {
                            Logging.log((Level)Logging.LEVEL_WARN, (String)"Mapillary API v3 returns a malformed URL in the Link header.", (Throwable)e);
                        }
                    }
                    if (url == null || !isNext) continue;
                    return url;
                }
            }
            return null;
        }

        public static String queryString(Bounds bounds) {
            if (bounds != null) {
                HashMap<String, String> parts = new HashMap<String, String>();
                parts.put("bbox", bounds.toBBox().toStringCSV(","));
                return StreetsideURL.queryString(parts);
            }
            return StreetsideURL.queryString(null);
        }

        public static String queryStreetsideString(Bounds bounds) {
            if (bounds != null) {
                HashMap<String, String> parts = new HashMap<String, String>();
                parts.put("bbox", bounds.toBBox().toStringCSV(","));
                return StreetsideURL.queryStreetsideBoundsString(parts);
            }
            return StreetsideURL.queryStreetsideBoundsString(null);
        }

        public static URL userURL() {
            return StreetsideURL.string2URL(BASE_URL, "me", StreetsideURL.queryString(null));
        }
    }
}

