/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.oauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openstreetmap.josm.plugins.streetside.oauth.OAuthUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideUser {
    private static String username;
    private static String imagesPolicy;
    private static String imagesHash;
    private static boolean isTokenValid;

    private StreetsideUser() {
    }

    public static synchronized String getUsername() {
        if (!isTokenValid) {
            return null;
        }
        if (username == null) {
            try {
                username = OAuthUtils.getWithHeader(StreetsideURL.APIv3.userURL()).getString("username");
            }
            catch (IOException e) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"Invalid Streetside token, resetting field", (Throwable)e);
                StreetsideUser.reset();
            }
        }
        return username;
    }

    public static synchronized Map<String, String> getSecrets() {
        if (!isTokenValid) {
            return null;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            if (imagesHash == null) {
                imagesHash = OAuthUtils.getWithHeader(StreetsideURL.uploadSecretsURL()).getString("images_hash", null);
            }
            hash.put("images_hash", imagesHash);
            if (imagesPolicy == null) {
                imagesPolicy = OAuthUtils.getWithHeader(StreetsideURL.uploadSecretsURL()).getString("images_policy");
            }
        }
        catch (IOException e) {
            Logging.log((Level)Logging.LEVEL_WARN, (String)"Invalid Streetside token, resetting field", (Throwable)e);
            StreetsideUser.reset();
        }
        hash.put("images_policy", imagesPolicy);
        return hash;
    }

    public static synchronized void reset() {
        username = null;
        imagesPolicy = null;
        imagesHash = null;
        isTokenValid = false;
        StreetsideProperties.ACCESS_TOKEN.put((String)StreetsideProperties.ACCESS_TOKEN.getDefaultValue());
    }

    public static synchronized void setTokenValid(boolean value) {
        isTokenValid = value;
    }

    static {
        isTokenValid = true;
    }
}

