/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.util.logging.Level;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.io.download.ImageDetailsDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.io.download.SequenceDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.PluginState;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.Logging;

public class StreetsideSquareDownloadRunnable
implements Runnable {
    private final Bounds bounds;

    public StreetsideSquareDownloadRunnable(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public void run() {
        PluginState.startDownload();
        StreetsideUtils.updateHelpText();
        new SequenceDownloadRunnable(StreetsideLayer.getInstance().getData(), this.bounds).run();
        if (Thread.interrupted()) {
            return;
        }
        Thread imgDetailsThread = new Thread(new ImageDetailsDownloadRunnable(StreetsideLayer.getInstance().getData(), this.bounds));
        imgDetailsThread.start();
        try {
            imgDetailsThread.join();
        }
        catch (InterruptedException e) {
            Logging.log((Level)Logging.LEVEL_WARN, (String)"Streetside download interrupted (probably because of closing the layer).", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            PluginState.finishDownload();
        }
        StreetsideUtils.updateHelpText();
        StreetsideLayer.invalidateInstance();
        StreetsideMainDialog.getInstance().updateImage();
    }
}

