/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import us.monoid.web.Resty;

public class TileDownloadingTask
implements Callable<String> {
    private String tileId;
    private final long startTime = System.currentTimeMillis();
    private StreetsideCache cache;
    protected CubemapBuilder cb;
    private final List<ITileDownloadingTaskListener> listeners = new CopyOnWriteArrayList<ITileDownloadingTaskListener>();
    boolean cancelled = false;

    public TileDownloadingTask(String id) {
        this.tileId = id;
        this.cb = CubemapBuilder.getInstance();
        this.addListener(CubemapBuilder.getInstance());
    }

    public final void addListener(ITileDownloadingTaskListener lis) {
        this.listeners.add(lis);
    }

    public String getId() {
        return this.tileId;
    }

    public void setId(String id) {
        this.tileId = id;
    }

    public StreetsideCache getCache() {
        return this.cache;
    }

    public void setCache(StreetsideCache cache) {
        this.cache = cache;
    }

    public CubemapBuilder getCb() {
        return this.cb;
    }

    public void setCb(CubemapBuilder cb) {
        this.cb = cb;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public String call() throws Exception {
        BufferedImage img = ImageIO.read(new Resty(new Resty.Option[0]).bytes(StreetsideURL.VirtualEarth.streetsideTile(this.tileId, false).toExternalForm()).stream());
        if (img == null) {
            Logging.error((String)I18n.tr((String)"Download of BufferedImage {0} is null!", (Object[])new Object[]{this.tileId}));
        }
        String faceId = CubemapUtils.getFaceIdFromTileId(this.tileId);
        Map<String, Map<String, BufferedImage>> faces2TilesMap = CubemapBuilder.getInstance().getCubemap().getFace2TilesMap();
        if (faces2TilesMap.get(faceId) == null) {
            faces2TilesMap.put(faceId, new HashMap());
        }
        faces2TilesMap.get(faceId).put(this.tileId, img);
        this.fireTileAdded(this.tileId);
        long endTime = System.currentTimeMillis();
        long runTime = this.startTime - endTime;
        Logging.debug((String)"Loaded image for tile {0} in {1} seconds", (Object[])new Object[]{this.tileId, CubemapUtils.msToString(runTime)});
        return this.tileId;
    }

    private void fireTileAdded(String id) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.tileAdded(id));
    }
}

