/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideChangesetListener;

public class StreetsideLocationChangeset
extends AbstractSet<StreetsideImage> {
    private final Set<StreetsideChangesetListener> listeners = new HashSet<StreetsideChangesetListener>();
    private final Set<StreetsideImage> changeset = Collections.newSetFromMap(new ConcurrentHashMap());

    public void addChangesetListener(StreetsideChangesetListener listener) {
        this.listeners.add(listener);
    }

    public void cleanChangeset() {
        this.changeset.clear();
        this.fireListeners();
    }

    private void fireListeners() {
        this.listeners.forEach(StreetsideChangesetListener::changesetChanged);
    }

    @Override
    public boolean add(StreetsideImage image) {
        boolean add = this.changeset.add(image);
        this.fireListeners();
        return add;
    }

    @Override
    public Iterator<StreetsideImage> iterator() {
        return this.changeset.iterator();
    }

    @Override
    public int size() {
        return this.changeset.size();
    }

    @Override
    public boolean remove(Object image) {
        boolean remove = this.changeset.remove(image);
        this.fireListeners();
        return remove;
    }
}

