/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.export;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImportedImage;
import org.openstreetmap.josm.tools.Logging;

public class StreetsideExportWriterThread
extends Thread {
    private final String path;
    private final ArrayBlockingQueue<BufferedImage> queue;
    private final ArrayBlockingQueue<StreetsideAbstractImage> queueImages;
    private final int amount;
    private final ProgressMonitor monitor;

    public StreetsideExportWriterThread(String path, ArrayBlockingQueue<BufferedImage> queue, ArrayBlockingQueue<StreetsideAbstractImage> queueImages, int amount, ProgressMonitor monitor) {
        this.path = path;
        this.queue = queue;
        this.queueImages = queueImages;
        this.amount = amount;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        this.monitor.setCustomText("Downloaded 0/" + this.amount);
        String finalPath = "";
        for (int i = 0; i < this.amount; ++i) {
            try {
                TiffImageMetadata exif;
                ImageMetadata metadata;
                JpegImageMetadata jpegMetadata;
                BufferedImage img = this.queue.take();
                StreetsideAbstractImage mimg = this.queueImages.take();
                if (this.path == null && mimg instanceof StreetsideImportedImage) {
                    String path = ((StreetsideImportedImage)mimg).getFile().getPath();
                    finalPath = path.substring(0, path.lastIndexOf(46));
                } else if (mimg instanceof StreetsideImage) {
                    finalPath = this.path + '/' + ((StreetsideImage)mimg).getId();
                } else if (mimg instanceof StreetsideImportedImage) {
                    finalPath = this.path + '/' + ((StreetsideImportedImage)mimg).getFile().getName();
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "jpg", outputStream);
                byte[] imageBytes = outputStream.toByteArray();
                TiffOutputSet outputSet = null;
                if (mimg instanceof StreetsideImportedImage && null != (jpegMetadata = (JpegImageMetadata)(metadata = Imaging.getMetadata((File)((StreetsideImportedImage)mimg).getFile()))) && null != (exif = jpegMetadata.getExif())) {
                    outputSet = exif.getOutputSet();
                }
                if (null == outputSet) {
                    outputSet = new TiffOutputSet();
                }
                TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
                TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGPSDirectory();
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
                gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
                gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)mimg.getMovingHe()));
                exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
                if (mimg instanceof StreetsideImportedImage) {
                    exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{mimg.getDate("yyyy/MM/dd HH:mm:ss")});
                } else if (mimg instanceof StreetsideImage) {
                    exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{mimg.getDate("yyyy/MM/dd HH/mm/ss")});
                }
                outputSet.setGPSInDegrees(mimg.getMovingLatLon().lon(), mimg.getMovingLatLon().lat());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(finalPath + ".jpg"));
                new ExifRewriter().updateExifMetadataLossless(imageBytes, (OutputStream)os, outputSet);
                ((OutputStream)os).close();
            }
            catch (InterruptedException e) {
                Logging.info((String)"Streetside export cancelled");
                return;
            }
            catch (IOException | ImageReadException | ImageWriteException e) {
                Logging.error((Throwable)e);
            }
            this.monitor.worked(10000 / this.amount);
            this.monitor.setCustomText("Downloaded " + (i + 1) + "/" + this.amount);
        }
    }
}

