/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideCubemap;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.TileDownloadingTask;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerHelpPopup;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerPanel;
import org.openstreetmap.josm.plugins.streetside.utils.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class CubemapBuilder
implements ITileDownloadingTaskListener,
StreetsideDataListener {
    private static CubemapBuilder instance;
    private StreetsideViewerHelpPopup streetsideViewerHelp;
    private StreetsideCubemap cubemap;
    protected boolean cancelled;
    private long startTime;

    private CubemapBuilder() {
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.startTime = System.currentTimeMillis();
        this.cubemap = null;
        this.cubemap = new StreetsideCubemap(newImage.getId(), newImage.getLatLon(), newImage.getHe());
        this.cubemap.setCd(newImage.getCd());
        this.downloadCubemapImages(this.cubemap.getId());
    }

    public void reload(String imageId) {
        if (this.cubemap != null && imageId.equals(this.cubemap.getId())) {
            CubemapBuilder.getInstance().getCubemap().resetFaces2TileMap();
            this.downloadCubemapImages(imageId);
        }
    }

    public void downloadCubemapImages(String imageId) {
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxThreadCount = 6 * maxCols * maxRows;
        int fails = 0;
        long startTime = System.currentTimeMillis();
        try {
            List results;
            ExecutorService pool = Executors.newFixedThreadPool(maxThreadCount);
            ArrayList<TileDownloadingTask> tasks = new ArrayList<TileDownloadingTask>(maxThreadCount);
            if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    int tileNr = 0;
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(tileNr++).toString());
                            tasks.add(new TileDownloadingTask(tileId));
                            Logging.debug((String)I18n.tr((String)"Starting tile downloading task for imageId {0}, cubeface {1}, tileNr {2}", (Object[])new Object[]{tileId, CubemapUtils.getFaceNumberForCount(i), String.valueOf(tileNr)}));
                        }
                    }
                }
                results = pool.invokeAll(tasks);
                for (Future ff : results) {
                    Logging.debug((String)I18n.tr((String)"Completed tile downloading task {0} in {1}", (Object[])new Object[]{ff.get(), CubemapUtils.msToString(startTime - System.currentTimeMillis())}));
                }
            } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString()));
                            tasks.add(new TileDownloadingTask(tileId));
                            Logging.debug((String)I18n.tr((String)"Starting tile downloading task for imageId {0}, cubeface {1}, tileID {2}", (Object[])new Object[]{imageId, CubemapUtils.getFaceNumberForCount(i), tileId}));
                        }
                    }
                }
                results = pool.invokeAll(tasks);
                for (Future ff : results) {
                    Logging.info((String)I18n.tr((String)"Completed tile downloading task {0} in {1}", (Object[])new Object[]{ff.get(), CubemapUtils.msToString(startTime - System.currentTimeMillis())}));
                }
            }
        }
        catch (Exception ee) {
            ++fails;
            Logging.error((String)"Error loading tile for image {0}", (Object[])new Object[]{imageId});
            ee.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long runTime = stopTime - startTime;
        Logging.info((String)I18n.tr((String)"Tile imagery downloading tasks completed in {0}", (Object[])new Object[]{CubemapUtils.msToString(runTime)}));
        if (fails > 0) {
            Logging.error((String)I18n.tr((String)"{0} downloading tasks failed.", (Object[])new Object[]{fails}));
        }
    }

    @Override
    public void tileAdded(String tileId) {
        int maxRows;
        int tileCount = 0;
        for (int i = 0; i < 6; ++i) {
            String faceNumber = CubemapUtils.getFaceNumberForCount(i);
            Map<String, BufferedImage> faceTileImages = CubemapBuilder.getInstance().getCubemap().getFace2TilesMap().get(faceNumber);
            tileCount += faceTileImages.values().size();
        }
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int n = maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        if (tileCount == 6 * maxCols * maxRows) {
            Logging.info((String)I18n.tr((String)"{0} tile images ready for building cumbemap faces for cubemap {0}", (Object[])new Object[]{tileCount, CubemapBuilder.getInstance().getCubemap().getId()}));
            this.buildCubemapFaces();
        } else {
            Logging.info((String)I18n.tr((String)"{0} tile images received for cubemap {1}", (Object[])new Object[]{Integer.valueOf(tileCount).toString(), CubemapBuilder.getInstance().getCubemap().getId()}));
        }
    }

    private void buildCubemapFaces() {
        int i;
        CubemapBox cmb = StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().getCubemapBox();
        ImageView[] views = cmb.getViews();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        Image[] finalImages = new Image[6];
        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                Map<String, BufferedImage> tileImages = CubemapBuilder.getInstance().getCubemap().getFace2TilesMap().get(CubemapUtils.getFaceNumberForCount(i));
                BufferedImage[] faceTileImages = new BufferedImage[maxCols * maxRows];
                for (int j = 0; j < maxCols * maxRows; ++j) {
                    BufferedImage currentTile;
                    String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(j).toString());
                    faceTileImages[j] = currentTile = tileImages.get(tileId);
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                int tileCount = 0;
                Map<String, Map<String, BufferedImage>> face2TilesMap = CubemapBuilder.getInstance().getCubemap().getFace2TilesMap();
                Map<String, BufferedImage> tileImages = face2TilesMap.get(CubemapUtils.getFaceNumberForCount(i));
                BufferedImage[] faceTileImages = new BufferedImage[StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 16 : 4];
                for (int j = 0; j < maxCols; ++j) {
                    for (int k = 0; k < maxRows; ++k) {
                        String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + CubemapUtils.convertDoubleCountNrto16TileNr(String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString())));
                        BufferedImage currentTile = tileImages.get(tileId);
                        faceTileImages[tileCount++] = currentTile;
                    }
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        }
        for (i = 0; i < 6; ++i) {
            views[i].setImage(finalImages[i]);
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().revalidate();
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().repaint();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().revalidate();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().repaint();
        long endTime = System.currentTimeMillis();
        long runTime = endTime - this.startTime;
        Logging.info((String)I18n.tr((String)"Completed downloading, assembling and setting cubemap imagery for cubemap {0} in {1}", (Object[])new Object[]{this.cubemap.getId(), CubemapUtils.msToString(runTime)}));
    }

    public synchronized StreetsideCubemap getCubemap() {
        return this.cubemap;
    }

    public static void setCubemap(StreetsideCubemap cubemap) {
        CubemapBuilder.getInstance().cubemap = cubemap;
    }

    public static CubemapBuilder getInstance() {
        if (instance == null) {
            instance = new CubemapBuilder();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }
}

