/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.ImageModifier;

public class RasterImageModifier
extends ImageModifier {
    private int cadastreBackground = -1;
    public static int cadastreBackgroundTransp = 0xFFFFFF;
    private boolean transparencyEnabled = false;

    public RasterImageModifier(BufferedImage bi) {
        this.setBufferedImage(bi);
        this.transparencyEnabled = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
        if (this.transparencyEnabled) {
            this.makeTransparent();
        }
        if (Main.pref.getBoolean("cadastrewms.invertGrey")) {
            this.invertGrey();
        }
    }

    private void invertGrey() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if ((this.transparencyEnabled || pixel == this.cadastreBackground) && (!this.transparencyEnabled || pixel == cadastreBackgroundTransp)) continue;
                this.bufferedImage.setRGB(x, y, this.reverseIfGrey(pixel));
            }
        }
    }

    private int reverseIfGrey(int pixel) {
        Color col = new Color(pixel);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        if (b == r && b == g) {
            pixel = 0 + ((byte)(255 - r) << 16) + ((byte)(255 - r) << 8) + (byte)(255 - r);
        }
        return pixel;
    }

    private void makeTransparent() {
        if (this.bufferedImage.getColorModel() instanceof ComponentColorModel || this.bufferedImage.getColorModel() instanceof IndexColorModel) {
            int width = this.bufferedImage.getWidth();
            int height = this.bufferedImage.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 2);
            boolean simplifyColors = Main.pref.getBoolean("cadastrewms.raster2bitsColors", false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = this.bufferedImage.getRGB(x, y);
                    Color c = new Color(rgb);
                    int r = c.getRed();
                    int g = c.getGreen();
                    int b = c.getBlue();
                    Color maskedColor = rgb == this.cadastreBackground ? (simplifyColors ? new Color(255, 255, 255, 0) : new Color(r, g, b, 0)) : (simplifyColors ? new Color(0, 0, 0, 255) : new Color(r, g, b, 255));
                    bi.setRGB(x, y, maskedColor.getRGB());
                }
            }
            this.setBufferedImage(bi);
        }
    }

    public static BufferedImage fixRasterImage(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 2);
        int[] rgbArray = new int[width * height];
        img.getRGB(0, 0, width, height, rgbArray, 0, width);
        bi.setRGB(0, 0, width, height, rgbArray, 0, width);
        return bi;
    }
}

