/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.models;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.plugins.public_transport.refs.TrackReference;
import org.openstreetmap.josm.tools.I18n;

public class TrackStoplistTableModel
extends DefaultTableModel {
    private Vector<Node> nodes = null;
    private Vector<String> times = null;
    private static Vector<String> columns = null;

    public TrackStoplistTableModel(TrackReference tr) {
        if (columns == null) {
            columns = new Vector();
            columns.add(I18n.tr((String)"Time", (Object[])new Object[0]));
            columns.add(I18n.tr((String)"Name", (Object[])new Object[0]));
            columns.add(I18n.tr((String)"Shelter", (Object[])new Object[0]));
        }
        this.nodes = new Vector();
        this.times = new Vector();
        this.setColumnIdentifiers(columns);
        this.addTableModelListener(tr);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public void addRow(Object[] obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow(int insPos, Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void addRow(String time) {
        this.insertRow(-1, time);
    }

    public void insertRow(int insPos, String time) {
        this.insertRow(insPos, null, time, "", new TransText(null));
    }

    @Override
    public void removeRow(int pos) {
        super.removeRow(pos);
        this.nodes.removeElementAt(pos);
        this.times.removeElementAt(pos);
    }

    public Node nodeAt(int i) {
        return this.nodes.elementAt(i);
    }

    public void setNodeAt(int i, Node node) {
        this.nodes.set(i, node);
    }

    public final Vector<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Vector<Node> nodes) {
        this.nodes = nodes;
    }

    public String timeAt(int i) {
        return this.times.elementAt(i);
    }

    public void setTimeAt(int i, String time) {
        this.times.set(i, time);
    }

    public final Vector<String> getTimes() {
        return this.times;
    }

    public void setTimes(Vector<String> times) {
        this.times = times;
    }

    public void insertRow(int insPos, Node node, String time, String name, TransText shelter) {
        Object[] buf = new Object[]{time, name, shelter};
        if (insPos == -1) {
            this.nodes.addElement(node);
            this.times.addElement(time);
            super.addRow(buf);
        } else {
            this.nodes.insertElementAt(node, insPos);
            this.times.insertElementAt(time, insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.nodes.clear();
        this.times.clear();
        super.setRowCount(0);
    }

    public void setDataVector(Vector<Vector<Object>> dataVector) {
        this.setDataVector(dataVector, columns);
    }
}

