/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public final class RouteUtils {
    private static final String PT_VERSION_TAG = "public_transport:version";
    public static final String TAG_ROUTE = "route";

    private RouteUtils() {
    }

    public static boolean isVersionTwoPTRoute(Relation r) {
        if (!RouteUtils.isPTRoute(r)) {
            return false;
        }
        if (!r.hasTag(PT_VERSION_TAG, "2")) {
            return false;
        }
        return !r.hasTag("bus", "on_demand");
    }

    public static boolean isVersionOnePTRoute(Relation r) {
        if (!RouteUtils.isPTRoute(r)) {
            return false;
        }
        if (r.get(PT_VERSION_TAG) == null) {
            return true;
        }
        return r.hasTag(PT_VERSION_TAG, "1");
    }

    public static boolean isPTRoute(Relation r) {
        if (r == null) {
            return false;
        }
        String[] acceptedRouteTags = new String[]{"bus", "trolleybus", "share_taxi", "tram", "light_rail", "subway", "train"};
        return r.hasTag(TAG_ROUTE, acceptedRouteTags);
    }

    public static boolean isRoute(Relation r) {
        return r.get(TAG_ROUTE) != null;
    }

    public static boolean isPTWay(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return false;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
            return !rm.getWay().hasTag("public_transport", "platform") && !rm.getWay().hasTag("highway", "platform") && !rm.getWay().hasTag("railway", "platform");
        }
        Relation nestedRelation = rm.getRelation();
        for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
            if (nestedRelationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            return false;
        }
        return true;
    }

    public static int isOnewayForPublicTransport(Way way) {
        if (!(!OsmUtils.isTrue((String)way.get("oneway")) && !OsmUtils.isReversed((String)way.get("oneway")) && !way.hasTag("junction", "roundabout") && !way.hasTag("highway", "motorway") || way.hasTag("busway", "lane") || way.hasTag("busway", "opposite_lane") || way.hasTag("busway:left", "lane") || way.hasTag("busway:right", "lane") || way.hasTag("oneway:bus", "no") || way.hasTag("oneway:psv", "no") || way.hasTag("trolley_wire", "backward"))) {
            if (OsmUtils.isReversed((String)way.get("oneway"))) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static int isOnewayForBicycles(Way way) {
        if (!(!OsmUtils.isTrue((String)way.get("oneway")) && !OsmUtils.isReversed((String)way.get("oneway")) && !way.hasTag("junction", "roundabout") || way.hasTag("busway", "lane") || way.hasTag("cycleway", "opposite_lane") || way.hasTag("cycleway:left", "lane") || way.hasTag("cycleway:right", "lane") || way.hasTag("oneway:bicycle", "no"))) {
            if (OsmUtils.isReversed((String)way.get("oneway"))) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static boolean waysTouch(Way w1, Way w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        Node w1FirstNode = w1.firstNode();
        Node w1LastNode = w1.lastNode();
        Node w2FirstNode = w2.firstNode();
        Node w2LastNode = w2.lastNode();
        return w1FirstNode == w2FirstNode || w1FirstNode == w2LastNode || w1LastNode == w2FirstNode || w1LastNode == w2LastNode;
    }

    public static boolean waysTouch(Collection<Way> c1, Collection<Way> c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        for (Way w1 : c1) {
            for (Way w2 : c2) {
                if (!RouteUtils.waysTouch(w1, w2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWaySuitableForBuses(Way way) {
        String[] acceptedHighwayTags = new String[]{"motorway", "trunk", "primary", "secondary", "tertiary", "unclassified", "road", "residential", "service", "motorway_link", "trunk_link", "primary_link", "secondary_link", "tertiary_link", "living_street", "bus_guideway", "road"};
        if (way.hasTag("highway", acceptedHighwayTags) || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane")) {
            return true;
        }
        return way.hasTag("highway", "pedestrian") && (way.hasTag("bus", new String[]{"yes", "designated"}) || way.hasTag("psv", new String[]{"yes", "designated"}));
    }

    public static boolean isWaySuitableForPublicTransport(Way way) {
        String[] acceptedRailwayTags = new String[]{"tram", "subway", "light_rail", "rail"};
        return RouteUtils.isWaySuitableForBuses(way) || way.hasTag("railway", acceptedRailwayTags);
    }

    public static boolean isBicycleRoute(Relation r) {
        if (r == null) {
            return false;
        }
        return r.hasTag(TAG_ROUTE, new String[]{"bicycle", "mtb"});
    }

    public static boolean isWaySuitableForBicycle(Way way) {
        return way.hasTag("highway", "cycleway") || !way.hasKey(new String[]{"highway", "motorway"}) && !way.hasKey(new String[]{"bicycle", "no"}) && !way.hasKey(new String[]{"bicycle", "use_sidepath"});
    }

    public static boolean isFootRoute(Relation r) {
        if (r == null) {
            return false;
        }
        return r.hasTag(TAG_ROUTE, new String[]{"foot", "walking", "hiking"});
    }

    public static boolean isHorseRoute(Relation r) {
        if (r == null) {
            return false;
        }
        return r.hasTag(TAG_ROUTE, "horse");
    }
}

