/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.download.UserQueryList;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SortPTRouteMembersAction;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class PTWizardAction
extends JosmAction {
    public boolean noDialogBox;
    private int closeCheck = 0;

    public PTWizardAction() {
        super(I18n.tr((String)"PT Wizard", (Object[])new Object[0]), "clock", I18n.tr((String)"Set up PT Assistant for more convenient use", (Object[])new Object[0]), null, false);
        this.putValue("help", HelpUtil.ht((String)"/Action/PTWizard"));
        this.putValue("toolbar", "help/PTWizard");
        MainApplication.getToolbar().register((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent e) {
        boolean defaultAction = false;
        boolean action = false;
        if (this.noDialogBox) {
            Set keySet = Main.pref.getKeySet();
            if (!keySet.contains("pt_assistant.wizard.pages")) {
                defaultAction = true;
            } else {
                String pages = Main.pref.get("pt_assistant.wizard.pages");
                if (pages.isEmpty()) {
                    defaultAction = true;
                }
            }
            if (defaultAction) {
                action = false;
                this.readPreferencesFromXML();
                this.addDefaultValues();
            }
            this.noDialogBox = false;
        } else {
            action = true;
            String pages = Main.pref.get("pt_assistant.wizard.pages");
            if (pages.isEmpty()) {
                this.readPreferencesFromXML();
                this.addDefaultValues();
            }
        }
        if (action) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            DoubleSplitDialog dsd = new DoubleSplitDialog();
            dsd.setPreferredSize(new Dimension(250, 300));
            dsd.setButtonIcons(new String[]{"ok", "cancel"});
            JScrollPane scrollPanel = new JScrollPane(panel);
            dsd.setContent(scrollPanel, false);
            this.nextAct(0, panel);
            String pages = Main.pref.get("pt_assistant.wizard.pages");
            int lastCheck = -1;
            try {
                block5: for (int i = 1; i <= Integer.parseInt(pages) + 1; ++i) {
                    if (lastCheck == this.closeCheck) {
                        return;
                    }
                    lastCheck = this.closeCheck;
                    ExtendedDialog dialog = dsd.showDialog();
                    switch (dialog.getValue()) {
                        case 1: {
                            this.nextAct(i, panel);
                            continue block5;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        }
    }

    private void readPreferencesFromXML() {
        System.out.println("READING FROM XML FILE");
        try {
            CachedFile cf = this.getCachedFile();
            if (cf == null) {
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader in = cf.getContentReader();){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.contains("{{{") || line.contains("}}}")) continue;
                    lines.add(line);
                }
                in.close();
                File f = new File(".tempfile.xml");
                FileWriter fw = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fw);
                for (String s : lines) {
                    out.write(s);
                }
                out.flush();
                out.close();
                fw.close();
                InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
                new CustomConfigurator.XMLCommandProcessor(Main.pref).openAndReadXML(is);
                f.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CachedFile getCachedFile() {
        try {
            return new CachedFile("https://josm.openstreetmap.de/wiki/Plugin/PT_Assistant/Wizard?format=txt").setHttpAccept("text");
        }
        catch (Exception e) {
            new Notification(I18n.tr((String)"Unable to connect to {0}", (Object[])new Object[]{"https://josm.openstreetmap.de/wiki/Plugin/PT_Assistant/Wizard"})).setIcon(2).show();
            return null;
        }
    }

    private void addDefaultValues() {
        String value1 = Main.pref.get("pt_assistant.wizard.1.suggestion");
        this.question1ChangeValues(value1);
        List question2Suggestion = Main.pref.getListOfLists("pt_assistant.wizard.2.suggestion");
        ArrayList<String> value2 = new ArrayList<String>();
        for (int i = 0; i < question2Suggestion.size(); ++i) {
            value2.add((String)((List)question2Suggestion.get(i)).get(0));
        }
        this.question2ChangeValues(value2);
        List question3Suggestion = Main.pref.getListOfLists("pt_assistant.wizard.3.suggestion");
        ArrayList<String> value3 = new ArrayList<String>();
        for (int i = 0; i < question3Suggestion.size(); ++i) {
            if (((List)question3Suggestion.get(i)).get(1) != "Default") continue;
            value3.add((String)((List)question3Suggestion.get(i)).get(0));
        }
        this.question3ChangeValues(value3);
        List question4Suggestion = Main.pref.getListOfLists("pt_assistant.wizard.4.suggestion");
        ArrayList<String> value4 = new ArrayList<String>();
        for (int i = 0; i < question4Suggestion.size(); ++i) {
            if (((List)question4Suggestion.get(i)).get(1) != "Default") continue;
            value4.add((String)((List)question4Suggestion.get(i)).get(0));
        }
        this.question4ChangeValues(value4);
    }

    private void addLabel(JPanel panel, int questionNumber, boolean Title, boolean Question, boolean Suggestion) {
        JTextArea j;
        if (Title) {
            String title = Main.pref.get("pt_assistant.wizard." + questionNumber + ".title");
            j = new JTextArea(I18n.tr((String)title, (Object[])new Object[0]));
            j.setLineWrap(true);
            j.setWrapStyleWord(true);
            j.setEditable(false);
            j.setOpaque(false);
            j.setFont(new Font("Serif", 1, 18));
            panel.add((Component)j, GBC.eol().fill(2));
        }
        if (Question) {
            String question = Main.pref.get("pt_assistant.wizard." + questionNumber + ".question");
            j = new JTextArea(I18n.tr((String)question, (Object[])new Object[0]));
            j.setLineWrap(true);
            j.setWrapStyleWord(true);
            j.setEditable(false);
            j.setOpaque(false);
            panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
            panel.add((Component)j, GBC.eol().fill(2));
        }
        if (Suggestion) {
            String suggestion = Main.pref.get("pt_assistant.wizard." + questionNumber + ".suggestion");
            j = new JTextArea(I18n.tr((String)("suggested value : " + suggestion), (Object[])new Object[0]));
            j.setLineWrap(true);
            j.setWrapStyleWord(true);
            j.setEditable(false);
            j.setOpaque(false);
            panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
            panel.add((Component)j, GBC.eol().fill(2));
        }
    }

    private void introduction(JPanel panel) {
        this.addLabel(panel, 0, true, false, false);
        String information = Main.pref.get("pt_assistant.wizard.0.information");
        JTextArea j = new JTextArea(I18n.tr((String)information, (Object[])new Object[0]));
        j.setLineWrap(true);
        j.setWrapStyleWord(true);
        j.setEditable(false);
        j.setOpaque(false);
        panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
        panel.add((Component)j, GBC.eol().fill(2));
    }

    private void question1(JPanel panel) {
        this.addLabel(panel, 1, true, true, false);
        String currentValue = Main.pref.get("properties.recently-added-tags");
        SpinnerNumberModel model = new SpinnerNumberModel(Integer.parseInt(currentValue), 0, 30, 1);
        JSpinner tagsArea = new JSpinner(model);
        panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
        panel.add((Component)tagsArea, GBC.eol().fill(2));
    }

    private void question2(JPanel panel) {
        this.addLabel(panel, 2, true, true, false);
        Box checkBoxPanel = Box.createVerticalBox();
        checkBoxPanel.setOpaque(true);
        checkBoxPanel.setBackground(Color.white);
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.2.suggestion");
        List currentList = Config.getPref().getList("toolbar");
        try {
            for (int i = 0; i < suggestionLists.size(); ++i) {
                String content = (String)((List)suggestionLists.get(i)).get(0);
                String value = (String)((List)suggestionLists.get(i)).get(1);
                JCheckBox con = new JCheckBox(content);
                if (currentList.contains(value)) {
                    con.setSelected(true);
                }
                checkBoxPanel.add(con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        checkBoxPanel.setBackground(Color.white);
        checkBoxPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
        panel.add((Component)checkBoxPanel, GBC.eol().fill(2));
    }

    private void question3(JPanel panel) {
        this.addLabel(panel, 3, true, true, false);
        Box checkBoxPanel = Box.createVerticalBox();
        checkBoxPanel.setOpaque(true);
        checkBoxPanel.setBackground(Color.white);
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.3.suggestion");
        List styleList = MapPaintStyles.getStyles().getStyleSources();
        try {
            for (int i = 0; i < suggestionLists.size(); ++i) {
                String paintStyle = (String)((List)suggestionLists.get(i)).get(0);
                JCheckBox con = new JCheckBox(paintStyle);
                for (StyleSource style : styleList) {
                    if (!style.title.equals(paintStyle)) continue;
                    con.setSelected(true);
                    break;
                }
                checkBoxPanel.add(con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        checkBoxPanel.setBackground(Color.white);
        checkBoxPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
        panel.add((Component)checkBoxPanel, GBC.eol().fill(2));
    }

    private void question4(JPanel panel) {
        this.addLabel(panel, 4, true, true, false);
        Box checkBoxPanel = Box.createVerticalBox();
        checkBoxPanel.setOpaque(true);
        checkBoxPanel.setBackground(Color.white);
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.4.suggestion");
        Map<String, UserQueryList.SelectorItem> items = this.restorePreferences();
        try {
            for (int i = 0; i < suggestionLists.size(); ++i) {
                String content = (String)((List)suggestionLists.get(i)).get(0);
                JCheckBox con = new JCheckBox(content);
                if (items.containsKey(content)) {
                    con.setSelected(true);
                }
                checkBoxPanel.add(con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        checkBoxPanel.setBackground(Color.white);
        checkBoxPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add((Component)new JLabel("<html><br></html>"), GBC.eol().fill(2));
        panel.add((Component)checkBoxPanel, GBC.eol().fill(2));
    }

    private void question1Action(JPanel panel) {
        String value = new String();
        Component[] components = panel.getComponents();
        panel.getComponents();
        for (Component comp : components) {
            if (!(comp instanceof JSpinner)) continue;
            JSpinner textField = (JSpinner)comp;
            Integer intValue = (Integer)textField.getValue();
            value = Integer.toString(intValue);
        }
        this.question1ChangeValues(value);
    }

    private void question1ChangeValues(String value) {
        StringSetting valueSetting = new StringSetting(value);
        System.out.println((String)valueSetting.getValue());
        Main.pref.putSetting("properties.recently-added-tags", (Setting)valueSetting);
    }

    private void question2to4Action(JPanel panel, int questionNumber) {
        Component[] components;
        ArrayList<String> finalValues = new ArrayList<String>();
        for (Component comp : components = panel.getComponents()) {
            Component[] checkBoxComponents;
            if (!(comp instanceof Box)) continue;
            Box checkBox = (Box)comp;
            for (Component checkComponent : checkBoxComponents = checkBox.getComponents()) {
                JCheckBox checks;
                if (!(checkComponent instanceof JCheckBox) || !(checks = (JCheckBox)checkComponent).isSelected()) continue;
                finalValues.add(checks.getText());
            }
        }
        switch (questionNumber) {
            case 2: {
                this.question2ChangeValues(finalValues);
                break;
            }
            case 3: {
                this.question3ChangeValues(finalValues);
                break;
            }
            case 4: {
                this.question4ChangeValues(finalValues);
                break;
            }
        }
    }

    private void question2ChangeValues(List<String> finalValues) {
        for (String fv : finalValues) {
            System.out.println(fv);
        }
        if (finalValues.contains("Sort stops in route relation")) {
            MainMenu.add((JMenu)MainApplication.getMenu().toolsMenu, (JosmAction)new SortPTRouteMembersAction());
        }
        List current = Config.getPref().getList("toolbar");
        ArrayList<Object> newList = new ArrayList<Object>();
        for (String[] k : current) {
            newList.add(k);
        }
        if (current.size() == 0) {
            String[] def;
            for (String deftool : def = this.defaultToolBar()) {
                newList.add(deftool);
            }
        }
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.2.suggestion");
        try {
            for (int i = 0; i < suggestionLists.size(); ++i) {
                String content = (String)((List)suggestionLists.get(i)).get(0);
                String value = (String)((List)suggestionLists.get(i)).get(1);
                if (finalValues.contains(content) && !newList.contains(value)) {
                    newList.add(value);
                    continue;
                }
                if (finalValues.contains(content) || !newList.contains(value)) continue;
                newList.remove(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LinkedList t = new LinkedList(newList);
        try {
            Config.getPref().putList("toolbar", t);
            MainApplication.getToolbar().refreshToolbarControl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void question3ChangeValues(List<String> finalValues) {
        List styleList = MapPaintStyles.getStyles().getStyleSources();
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.3.suggestion");
        try {
            block2: for (int i = 0; i < suggestionLists.size(); ++i) {
                String paintStyle = (String)((List)suggestionLists.get(i)).get(0);
                String url = (String)((List)suggestionLists.get(i)).get(2);
                if (finalValues.contains(paintStyle)) {
                    boolean exists = false;
                    for (StyleSource style : styleList) {
                        if (!style.title.equals(paintStyle)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    SourceEntry source = new SourceEntry(SourceType.MAP_PAINT_STYLE, url, null, paintStyle, true);
                    MapPaintStyles.addStyle((SourceEntry)source);
                    continue;
                }
                for (StyleSource style : styleList) {
                    if (!style.title.equals(paintStyle)) continue;
                    SourceEntry source = new SourceEntry(SourceType.MAP_PAINT_STYLE, url, null, paintStyle, true);
                    MapPaintStyles.removeStyle((SourceEntry)source);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void question4ChangeValues(List<String> finalValues) {
        List suggestionLists = Main.pref.getListOfLists("pt_assistant.wizard.4.suggestion");
        ArrayList<UserQueryList.SelectorItem> itemList = new ArrayList<UserQueryList.SelectorItem>();
        ArrayList<String> unmarkedKeyList = new ArrayList<String>();
        Map<String, UserQueryList.SelectorItem> items = this.restorePreferences();
        for (List keys : suggestionLists) {
            String Key2 = (String)keys.get(0);
            if (finalValues.contains(Key2)) continue;
            unmarkedKeyList.add(Key2);
        }
        block3: for (String fv : finalValues) {
            if (items.containsKey(fv)) continue;
            for (List suggestions : suggestionLists) {
                String key = (String)suggestions.get(0);
                if (key != fv) continue;
                String Value = "";
                for (int i = 2; i < suggestions.size(); ++i) {
                    Value = Value + (String)suggestions.get(i);
                }
                UserQueryList.SelectorItem item = new UserQueryList.SelectorItem(key, Value);
                itemList.add(item);
                continue block3;
            }
        }
        for (String unmarkedKey : unmarkedKeyList) {
            if (!items.containsKey(unmarkedKey)) continue;
            items.remove(unmarkedKey);
        }
        for (UserQueryList.SelectorItem item : itemList) {
            items.put(item.getKey(), item);
        }
        try {
            this.savePreferences(items);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, UserQueryList.SelectorItem> restorePreferences() {
        List toRetrieve = Config.getPref().getListOfMaps("download.overpass.queries", Collections.emptyList());
        HashMap<String, UserQueryList.SelectorItem> result = new HashMap<String, UserQueryList.SelectorItem>();
        DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss, dd-MM-yyyy");
        for (Map entry : toRetrieve) {
            try {
                String key = (String)entry.get("key");
                String query = (String)entry.get("query");
                String lastEditText = (String)entry.get("lastEdit");
                LocalDateTime lastEdit = lastEditText == null ? LocalDateTime.MIN : LocalDateTime.parse(lastEditText, FORMAT);
                result.put(key, new UserQueryList.SelectorItem(key, query, lastEdit));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void savePreferences(Map<String, UserQueryList.SelectorItem> items) {
        DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss, dd-MM-yyyy");
        ArrayList toSave = new ArrayList(items.size());
        for (UserQueryList.SelectorItem item : items.values()) {
            HashMap<String, String> it = new HashMap<String, String>();
            it.put("key", item.getKey());
            it.put("query", item.getQuery());
            it.put("lastEdit", item.getLastEdit().format(FORMAT));
            toSave.add(it);
        }
        Config.getPref().putListOfMaps("download.overpass.queries", toSave);
    }

    private String[] defaultToolBar() {
        String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "imagery-offset", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Facilities/Tourism", "tagginggroup_Facilities/Food+Drinks", "|", "tagginggroup_Man Made/Historic Places", "|", "tagginggroup_Man Made/Man Made"};
        return deftoolbar;
    }

    private void nextAct(int pageNumber, JPanel panel) {
        switch (pageNumber) {
            case 2: {
                this.question1Action(panel);
                break;
            }
            case 3: {
                this.question2to4Action(panel, 2);
                break;
            }
            case 4: {
                this.question2to4Action(panel, 3);
                break;
            }
            case 5: {
                this.question2to4Action(panel, 4);
                break;
            }
        }
        panel.removeAll();
        switch (pageNumber) {
            case 0: {
                this.introduction(panel);
                break;
            }
            case 1: {
                this.question1(panel);
                break;
            }
            case 2: {
                this.question2(panel);
                break;
            }
            case 3: {
                this.question3(panel);
                break;
            }
            case 4: {
                this.question4(panel);
                break;
            }
        }
    }

    private class DoubleSplitDialog
    extends ExtendedDialog {
        public DoubleSplitDialog() {
            super(Main.parent, I18n.tr((String)"PT Wizard", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            PTWizardAction.this.closeCheck++;
            super.buttonAction(buttonIndex, evt);
        }
    }
}

