/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SortPTRouteMembersAction;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class RouteChecker
extends Checker {
    private boolean hasGap = false;
    List<RelationMember> sortedMembers;
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;

    public RouteChecker(Relation relation, Test test) {
        super(relation, test);
    }

    protected void performSortingTest() {
        if (this.relation.hasTag("fixme:relation", "order members")) {
            TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3711);
            builder.message(I18n.tr((String)"PT: Route needs to be sorted, found tag fixme:relation=order members", (Object[])new Object[0]));
            builder.primitives(new OsmPrimitive[]{this.relation});
            TestError e = builder.build();
            this.errors.add(e);
            return;
        }
        ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            waysToCheck.add(rm);
        }
        if (waysToCheck.isEmpty()) {
            return;
        }
        List<Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>>> gaps = this.getGaps(waysToCheck);
        int numOfGaps = gaps.size();
        if (numOfGaps > 0) {
            this.hasGap = true;
            RelationSorter sorter = new RelationSorter();
            this.sortedMembers = sorter.sortMembers(waysToCheck);
            int numOfGapsAfterSort = this.countGaps(this.sortedMembers);
            if (numOfGapsAfterSort == 0) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3711);
                builder.message(I18n.tr((String)"PT: Route contains a gap that can be fixed by sorting", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{this.relation});
                TestError e = builder.build();
                this.errors.add(e);
            } else if (numOfGapsAfterSort < numOfGaps) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3712);
                builder.message(I18n.tr((String)"PT: Route gaps can decrease by sorting members. Further validations will be required", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{this.relation});
                TestError e = builder.build();
                this.errors.add(e);
            } else if (numOfGaps == numOfGapsAfterSort) {
                for (Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>> gap : gaps) {
                    Way after;
                    Way before = ((RelationMember)waysToCheck.get((Integer)gap.a)).getWay();
                    Way fix = this.findTrivialFix(before, (WayConnectionType.Direction)((Pair)gap.b).a, after = ((RelationMember)waysToCheck.get((Integer)gap.a + 1)).getWay(), (WayConnectionType.Direction)((Pair)gap.b).b);
                    if (fix == null) continue;
                    TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3710);
                    builder.message(I18n.tr((String)"PT: Route gap can be closed by adding a single way", (Object[])new Object[0]));
                    builder.primitives(new OsmPrimitive[]{this.relation, before, fix, after});
                    TestError e = builder.build();
                    this.errors.add(e);
                }
            }
        }
    }

    private Way findTrivialFix(Way before, WayConnectionType.Direction beforeDirection, Way after, WayConnectionType.Direction afterDirection) {
        Node startNode = beforeDirection == WayConnectionType.Direction.FORWARD ? before.lastNode() : before.firstNode();
        Node lastNode = afterDirection == WayConnectionType.Direction.FORWARD ? after.firstNode() : after.lastNode();
        List candidates = startNode.getParentWays();
        candidates.removeIf(w -> !RouteUtils.isWaySuitableForPublicTransport(w));
        for (Way candidate : candidates) {
            if (candidate.equals((Object)before) || (!candidate.firstNode().equals((Object)startNode) || !candidate.lastNode().equals((Object)lastNode)) && (!candidate.lastNode().equals((Object)startNode) || !candidate.firstNode().equals((Object)lastNode))) continue;
            return candidate;
        }
        return null;
    }

    protected boolean performFromToTagsTest() {
        String to;
        if (this.manager.getPTStopCount() == 0) {
            return false;
        }
        boolean foundError = false;
        String from = this.relation.get("from");
        if (from != null) {
            from = from.toLowerCase();
            PTStop stop = this.manager.getFirstStop();
            OsmPrimitive primitive = this.checkPTStopName(stop, from);
            if (primitive != null) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3701);
                builder.message(I18n.tr((String)"PT: The name of the first stop does not match the \"from\" tag of the route relation", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{primitive, this.relation});
                TestError e = builder.build();
                this.errors.add(e);
                foundError = true;
            }
        }
        if ((to = this.relation.get("to")) != null) {
            to = to.toLowerCase();
            PTStop stop = this.manager.getLastStop();
            OsmPrimitive primitive = this.checkPTStopName(stop, to);
            if (primitive != null) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3701);
                builder.message(I18n.tr((String)"PT: The name of the last stop does not match the \"to\" tag of the route relation", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{primitive, this.relation});
                TestError e = builder.build();
                this.errors.add(e);
                foundError = true;
            }
        }
        return foundError;
    }

    protected void performFirstLastWayStopTest() {
        TestError e;
        ArrayList<OsmPrimitive> prims;
        TestError.Builder builder;
        if (this.manager.getPTStopCount() == 0 || this.manager.getPTWayCount() == 0) {
            return;
        }
        PTStop stop = this.manager.getFirstStop();
        Way way = this.manager.getFirstWay();
        if (!way.equals((Object)this.assigner.get(stop))) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3702);
            builder.message(I18n.tr((String)"PT: The first stop of the route does not match the first way", (Object[])new Object[0]));
            prims = new ArrayList<OsmPrimitive>(Arrays.asList(way, this.relation));
            if (stop.getPlatform() != null) {
                prims.add(stop.getPlatform());
            }
            if (stop.getStopPosition() != null) {
                prims.add((OsmPrimitive)stop.getStopPosition());
            }
            builder.primitives(prims);
            e = builder.build();
            this.errors.add(e);
        }
        stop = this.manager.getLastStop();
        way = this.manager.getLastWay();
        if (!way.equals((Object)this.assigner.get(stop))) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3702);
            builder.message(I18n.tr((String)"PT: The last stop of the route does not match the last way", (Object[])new Object[0]));
            prims = new ArrayList<OsmPrimitive>(Arrays.asList(way, this.relation));
            if (stop.getPlatform() != null) {
                prims.add(stop.getPlatform());
            }
            if (stop.getStopPosition() != null) {
                prims.add((OsmPrimitive)stop.getStopPosition());
            }
            builder.primitives(prims);
            e = builder.build();
            this.errors.add(e);
        }
    }

    private OsmPrimitive checkPTStopName(PTStop stop, String name) {
        ArrayList<String> toCheck = new ArrayList<String>();
        OsmPrimitive primitive = stop.getPlatform();
        if (primitive != null) {
            toCheck.addAll(this.getPrimitiveNameTags(primitive));
        }
        primitive = stop.getStopPosition();
        if (toCheck.isEmpty() && primitive != null) {
            toCheck.addAll(this.getPrimitiveNameTags(primitive));
        }
        for (String value : toCheck) {
            if (!value.equals(name)) continue;
            return null;
        }
        return primitive;
    }

    private List<String> getPrimitiveNameTags(OsmPrimitive primitive) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry entry : primitive.getInterestingTags().entrySet()) {
            if (!"name".equals(entry.getKey()) && !((String)entry.getKey()).contains("name:")) continue;
            ret.add(((String)entry.getValue()).toLowerCase());
        }
        return ret;
    }

    public boolean hasGaps(List<RelationMember> waysToCheck) {
        return this.countGaps(waysToCheck) > 0;
    }

    private int countGaps(List<RelationMember> waysToCheck) {
        return this.getGaps(waysToCheck).size();
    }

    private List<Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>>> getGaps(List<RelationMember> waysToCheck) {
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        ArrayList<Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>>> gaps = new ArrayList<Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>>>();
        for (int i = 0; i < links.size() - 1; ++i) {
            WayConnectionType link = (WayConnectionType)links.get(i);
            if (link.linkNext) continue;
            gaps.add((Pair<Integer, Pair<WayConnectionType.Direction, WayConnectionType.Direction>>)new Pair((Object)i, (Object)new Pair((Object)link.direction, (Object)((WayConnectionType)links.get((int)(i + 1))).direction)));
        }
        return gaps;
    }

    public List<RelationMember> getSortedMembers() {
        return this.sortedMembers;
    }

    public boolean getHasGap() {
        return this.hasGap;
    }

    protected static Command fixSortingError(TestError testError) {
        if (testError.getCode() != 3711 && testError.getCode() != 3712) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        Relation sortedRelation = new Relation(originalRelation);
        SortPTRouteMembersAction.sortPTRouteMembers(sortedRelation);
        return new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)sortedRelation);
    }

    protected static Command fixTrivialError(TestError testError) {
        if (testError.getCode() != 3710) {
            return null;
        }
        ArrayList primitives = new ArrayList(testError.getPrimitives());
        Relation originalRelation = (Relation)primitives.get(0);
        Way before = (Way)primitives.get(1);
        Way fix = (Way)primitives.get(2);
        int index = 0;
        List members = originalRelation.getMembers();
        for (index = 0; index < members.size() && !((RelationMember)members.get(index)).getMember().equals((Object)before); ++index) {
        }
        Relation fixedRelation = new Relation(originalRelation);
        fixedRelation.addMember(index + 1, new RelationMember(null, (OsmPrimitive)fix));
        return new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)fixedRelation);
    }

    public PTRouteDataManager getManager() {
        return this.manager;
    }

    public void setManager(PTRouteDataManager manager) {
        this.manager = manager;
    }

    public StopToWayAssigner getAssigner() {
        return this.assigner;
    }

    public void setAssigner(StopToWayAssigner assigner) {
        this.assigner = assigner;
    }
}

