/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.layer.validation.PaintVisitor;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class PTAssistantPaintVisitor
extends PaintVisitor {
    private static final String Node = null;
    private final Graphics g;
    private final MapView mv;

    public PTAssistantPaintVisitor(Graphics g, MapView mv) {
        super((Graphics2D)g, mv);
        this.g = g;
        this.mv = mv;
    }

    public void visit(Relation r) {
        if (RouteUtils.isBicycleRoute(r) || RouteUtils.isFootRoute(r) || RouteUtils.isHorseRoute(r)) {
            this.drawCycleRoute(r);
            return;
        }
        ArrayList<RelationMember> rmList = new ArrayList<RelationMember>();
        ArrayList<RelationMember> revisitedWayList = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            if (PTStop.isPTStopPosition(rm)) {
                this.drawStop(rm.getMember(), true);
                continue;
            }
            if (PTStop.isPTPlatform(rm)) {
                this.drawStop(rm.getMember(), false);
                continue;
            }
            if (!RouteUtils.isPTWay(rm)) continue;
            if (rm.isWay()) {
                if (rmList.contains(rm)) {
                    if (!revisitedWayList.contains(rm)) {
                        this.visit(rm.getWay(), true);
                        revisitedWayList.add(rm);
                    }
                } else {
                    this.visit(rm.getWay(), false);
                }
            } else if (rm.isRelation()) {
                this.visit(rm.getRelation());
            }
            rmList.add(rm);
        }
        HashMap<Long, String> stopOrderMap = new HashMap<Long, String>();
        int stopCount = 1;
        for (RelationMember rm : r.getMembers()) {
            if (!PTStop.isPTStop(rm) && (!rm.getMember().isIncomplete() || !rm.isNode() && !rm.hasRole(new String[]{"stop"}) && !rm.hasRole(new String[]{"stop_entry_only"}) && !rm.hasRole(new String[]{"stop_exit_only"}) && !rm.hasRole(new String[]{"platform"}) && !rm.hasRole(new String[]{"platform_entry_only"}) && !rm.hasRole(new String[]{"platform_exit_only"}))) continue;
            StringBuilder sb = new StringBuilder();
            if (stopOrderMap.containsKey(rm.getUniqueId())) {
                sb.append((String)stopOrderMap.get(rm.getUniqueId())).append(";").append(stopCount);
            } else {
                if (r.hasKey("ref")) {
                    sb.append(r.get("ref"));
                } else if (r.hasKey("name")) {
                    sb.append(r.get("name"));
                } else {
                    sb.append("NA");
                }
                sb.append(" - ").append(stopCount);
            }
            stopOrderMap.put(rm.getUniqueId(), sb.toString());
            try {
                if (PTStop.isPTStopPosition(rm)) {
                    this.drawStopLabel(rm.getMember(), sb.toString(), false);
                } else if (PTStop.isPTPlatform(rm)) {
                    this.drawStopLabel(rm.getMember(), sb.toString(), true);
                }
            }
            catch (NullPointerException ex) {
                Logging.trace((Throwable)ex);
            }
            ++stopCount;
        }
    }

    private void drawCycleRoute(Relation r) {
        ArrayList<RelationMember> members = new ArrayList<RelationMember>(r.getMembers());
        members.removeIf(m -> !m.isWay());
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(members);
        for (int i = 0; i < links.size(); ++i) {
            WayConnectionType link = (WayConnectionType)links.get(i);
            Way way = ((RelationMember)members.get(i)).getWay();
            if (!link.isOnewayLoopForwardPart && !link.isOnewayLoopBackwardPart) {
                if (way.isSelected()) {
                    this.drawWay(way, new Color(0, 255, 0, 100));
                    continue;
                }
                this.drawWay(way, new Color(0, 255, 255, 100));
                continue;
            }
            if (link.isOnewayLoopForwardPart) {
                if (way.isSelected()) {
                    this.drawWay(way, new Color(255, 20, 147, 100));
                    continue;
                }
                this.drawWay(way, new Color(255, 0, 0, 100));
                continue;
            }
            if (way.isSelected()) {
                this.drawWay(way, new Color(128, 0, 128, 100));
                continue;
            }
            this.drawWay(way, new Color(0, 0, 255, 100));
        }
    }

    private void drawWay(Way way, Color color) {
        List nodes = way.getNodes();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            this.drawSegment((Node)nodes.get(i), (Node)nodes.get(i + 1), color, 1, false);
        }
    }

    public void visit(Way w, boolean revisit) {
        if (w == null) {
            return;
        }
        int oneway = 0;
        if (w.hasTag("junction", "roundabout") || w.hasTag("highway", "motorway")) {
            oneway = 1;
        } else if (w.hasTag("oneway", "1") || w.hasTag("oneway", "yes") || w.hasTag("oneway", "true")) {
            oneway = w.hasTag("busway", "lane") || w.hasTag("busway:left", "lane") || w.hasTag("busway:right", "lane") || w.hasTag("oneway:bus", "no") || w.hasTag("busway", "opposite_lane") || w.hasTag("oneway:psv", "no") || w.hasTag("trolley_wire", "backward") ? 2 : 1;
        } else if (w.hasTag("oneway", "-1") || w.hasTag("oneway", "reverse")) {
            oneway = w.hasTag("busway", "lane") || w.hasTag("busway:left", "lane") || w.hasTag("busway:right", "lane") || w.hasTag("oneway:bus", "no") || w.hasTag("busway", "opposite_lane") || w.hasTag("oneway:psv", "no") || w.hasTag("trolley_wire", "backward") ? -2 : -1;
        }
        this.visit(w.getNodes(), oneway, revisit);
    }

    public void visit(List<Node> nodes, int oneway, boolean revisit) {
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            if (!revisit) {
                this.drawSegment(lastN, n, new Color(128, 0, 128, 100), oneway, revisit);
            } else {
                this.drawSegment(lastN, n, new Color(0, 0, 0, 180), oneway, revisit);
            }
            lastN = n;
        }
    }

    public void visit(Node n) {
        if (n.isDrawable() && this.isNodeVisible(n)) {
            this.drawNode(n, Color.BLUE);
        }
    }

    protected void drawSegment(Node n1, Node n2, Color color, int oneway, boolean revisit) {
        if (n1.isDrawable() && n2.isDrawable() && this.isSegmentVisible(n1, n2)) {
            try {
                this.drawSegment(this.mv.getPoint(n1), this.mv.getPoint(n2), color, oneway, revisit);
            }
            catch (NullPointerException ex) {
                Logging.trace((Throwable)ex);
            }
        }
    }

    protected void drawSegment(Point p1, Point p2, Color color, int oneway, boolean revisit) {
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 9.0 * Math.cos(t);
        double sinT = 9.0 * Math.sin(t);
        if (revisit) {
            this.g.setColor(new Color(0, 0, 0, 140));
            int[] xPointsMiddle = new int[]{(int)((double)p1.x + 0.3 * cosT), (int)((double)p2.x + 0.3 * cosT), (int)((double)p2.x - 0.3 * cosT), (int)((double)p1.x - 0.3 * cosT)};
            int[] yPointsMiddle = new int[]{(int)((double)p1.y - 0.3 * sinT), (int)((double)p2.y - 0.3 * sinT), (int)((double)p2.y + 0.3 * sinT), (int)((double)p1.y + 0.3 * sinT)};
            this.g.fillPolygon(xPointsMiddle, yPointsMiddle, 4);
            this.g.setColor(color);
            int[] xPointsBottom = new int[]{(int)((double)p1.x - cosT + 0.2 * cosT), (int)((double)p2.x - cosT + 0.2 * cosT), (int)((double)p2.x - 1.3 * cosT), (int)((double)p1.x - 1.3 * cosT)};
            int[] yPointsBottom = new int[]{(int)((double)p1.y + sinT - 0.2 * sinT), (int)((double)p2.y + sinT - 0.2 * sinT), (int)((double)p2.y + 1.3 * sinT), (int)((double)p1.y + 1.3 * sinT)};
            this.g.fillPolygon(xPointsBottom, yPointsBottom, 4);
            int[] xPointsTop = new int[]{(int)((double)p1.x + 1.3 * cosT), (int)((double)p2.x + 1.3 * cosT), (int)((double)p2.x + cosT - 0.2 * cosT), (int)((double)p1.x + cosT - 0.2 * cosT)};
            int[] yPointsTop = new int[]{(int)((double)p1.y - 1.3 * sinT), (int)((double)p2.y - 1.3 * sinT), (int)((double)p2.y - sinT + 0.2 * sinT), (int)((double)p1.y - sinT + 0.2 * sinT)};
            this.g.fillPolygon(xPointsTop, yPointsTop, 4);
        } else {
            int[] xPoints = new int[]{(int)((double)p1.x + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)((double)p1.x - cosT)};
            int[] yPoints = new int[]{(int)((double)p1.y - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)((double)p1.y + sinT)};
            this.g.setColor(color);
            this.g.fillPolygon(xPoints, yPoints, 4);
            this.g.fillOval(p1.x - 9, p1.y - 9, 18, 18);
            this.g.fillOval(p2.x - 9, p2.y - 9, 18, 18);
        }
        if (oneway != 0) {
            int[] yDrawTriangle;
            int[] xDrawTriangle;
            int[] yFillTriangle;
            int[] xFillTriangle;
            double middleX = (double)(p1.x + p2.x) / 2.0;
            double middleY = (double)(p1.y + p2.y) / 2.0;
            double cosTriangle = 6.0 * Math.cos(t);
            double sinTriangle = 6.0 * Math.sin(t);
            this.g.setColor(Color.WHITE);
            if (oneway > 0) {
                xFillTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX + 2.0 * sinTriangle)};
                yFillTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY + 2.0 * cosTriangle)};
                this.g.fillPolygon(xFillTriangle, yFillTriangle, 3);
                if (oneway == 2) {
                    xDrawTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX - 2.0 * sinTriangle)};
                    yDrawTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY - 2.0 * cosTriangle)};
                    this.g.drawPolygon(xDrawTriangle, yDrawTriangle, 3);
                }
            }
            if (oneway < 0) {
                xFillTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX - 2.0 * sinTriangle)};
                yFillTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY - 2.0 * cosTriangle)};
                this.g.fillPolygon(xFillTriangle, yFillTriangle, 3);
                if (oneway == -2) {
                    xDrawTriangle = new int[]{(int)(middleX + cosTriangle), (int)(middleX - cosTriangle), (int)(middleX + 2.0 * sinTriangle)};
                    yDrawTriangle = new int[]{(int)(middleY - sinTriangle), (int)(middleY + sinTriangle), (int)(middleY + 2.0 * cosTriangle)};
                    this.g.drawPolygon(xDrawTriangle, yDrawTriangle, 3);
                }
            }
        }
    }

    protected void drawNode(Node n, Color color) {
        if (this.mv == null || this.g == null) {
            return;
        }
        Point p = this.mv.getPoint(n);
        if (p == null) {
            return;
        }
        this.g.setColor(color);
        this.g.drawOval(p.x - 5, p.y - 5, 10, 10);
    }

    protected void drawStop(OsmPrimitive primitive, Boolean stopPosition) {
        Node n = new Node(primitive.getBBox().getCenter());
        Point p = this.mv.getPoint(n);
        this.g.setColor(Color.BLUE);
        if (stopPosition.booleanValue()) {
            this.g.fillOval(p.x - 8, p.y - 8, 16, 16);
        } else {
            this.g.fillRect(p.x - 8, p.y - 8, 16, 16);
        }
    }

    protected void drawStopLabel(OsmPrimitive primitive, String label, Boolean platform) {
        Node n = new Node(primitive.getBBox().getCenter());
        Point p = this.mv.getPoint(n);
        if (label != null && !label.equals("")) {
            Font stringFont = new Font("SansSerif", 0, 24);
            if (platform.booleanValue()) {
                this.g.setColor(new Color(255, 255, 102));
                this.g.setFont(stringFont);
                this.g.drawString(label, p.x + 20, p.y - 40);
            } else {
                this.g.setColor(Color.WHITE);
                this.g.setFont(stringFont);
                this.g.drawString(label, p.x + 20, p.y - 20);
            }
        }
        ArrayList<String> parentsLabelList = new ArrayList<String>();
        for (Object parent : primitive.getReferrers()) {
            Relation relation;
            if (!parent.getType().equals((Object)OsmPrimitiveType.RELATION) || !RouteUtils.isVersionTwoPTRoute(relation = (Relation)parent) || relation.get("ref") == null || relation.get("ref").equals("")) continue;
            boolean stringFound = false;
            for (String s : parentsLabelList) {
                if (!s.equals(relation.get("ref"))) continue;
                stringFound = true;
            }
            if (stringFound) continue;
            parentsLabelList.add(relation.get("ref"));
        }
        Collections.sort(parentsLabelList, new RefTagComparator());
        StringBuilder sb = new StringBuilder();
        for (String s : parentsLabelList) {
            sb.append(s).append(";");
        }
        if (sb.length() > 0) {
            String parentsLabel = sb.substring(0, sb.length() - 1);
            this.g.setColor(new Color(255, 20, 147));
            Font parentLabelFont = new Font("SansSerif", 2, 20);
            this.g.setFont(parentLabelFont);
            this.g.drawString(parentsLabel, p.x + 20, p.y + 20);
        }
    }

    protected void visitFixVariants(HashMap<Character, List<PTWay>> fixVariants, HashMap<Way, List<Character>> wayColoring) {
        this.drawFixVariantsWithParallelLines(wayColoring);
        Color[] colors = new Color[]{new Color(255, 0, 0, 150), new Color(0, 255, 0, 150), new Color(0, 0, 255, 150), new Color(255, 255, 0, 150), new Color(0, 255, 255, 150)};
        int colorIndex = 0;
        double letterX = MainApplication.getMap().mapView.getBounds().getMinX() + 20.0;
        double letterY = MainApplication.getMap().mapView.getBounds().getMinY() + 100.0;
        for (Map.Entry<Character, List<PTWay>> entry : fixVariants.entrySet()) {
            Character c = entry.getKey();
            if (fixVariants.get(c) == null) continue;
            this.drawFixVariantLetter(c.toString(), colors[colorIndex % 5], letterX, letterY);
            ++colorIndex;
            letterY += 60.0;
        }
        if (!fixVariants.isEmpty()) {
            this.drawFixVariantLetter("Esc", Color.WHITE, letterX, letterY);
        }
    }

    private void drawFixVariant(List<PTWay> fixVariant, Color color) {
        for (PTWay ptway : fixVariant) {
            for (Way way : ptway.getWays()) {
                for (Pair nodePair : way.getNodePairs(false)) {
                    this.drawSegment((Node)nodePair.a, (Node)nodePair.b, color, 0, false);
                }
            }
        }
    }

    protected void drawFixVariantsWithParallelLines(Map<Way, List<Character>> wayColoring) {
        HashMap<Character, Color> colors = new HashMap<Character, Color>();
        colors.put(Character.valueOf('A'), new Color(255, 0, 0, 200));
        colors.put(Character.valueOf('B'), new Color(0, 255, 0, 200));
        colors.put(Character.valueOf('C'), new Color(0, 0, 255, 200));
        colors.put(Character.valueOf('D'), new Color(255, 255, 0, 200));
        colors.put(Character.valueOf('E'), new Color(0, 255, 255, 200));
        for (Map.Entry<Way, List<Character>> entry : wayColoring.entrySet()) {
            Way way = entry.getKey();
            List<Character> letterList = wayColoring.get(way);
            ArrayList<Color> wayColors = new ArrayList<Color>();
            for (Character letter : letterList) {
                wayColors.add((Color)colors.get(letter));
            }
            for (Pair nodePair : way.getNodePairs(false)) {
                this.drawSegmentWithParallelLines((Node)nodePair.a, (Node)nodePair.b, wayColors);
            }
        }
    }

    protected void drawSegmentWithParallelLines(Node n1, Node n2, List<Color> colors) {
        if (!(n1.isDrawable() && n2.isDrawable() && this.isSegmentVisible(n1, n2))) {
            return;
        }
        Point p1 = this.mv.getPoint(n1);
        Point p2 = this.mv.getPoint(n2);
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 9.0 * Math.cos(t);
        double sinT = 9.0 * Math.sin(t);
        double heightCosT = 9.0 * Math.cos(t);
        double heightSinT = 9.0 * Math.sin(t);
        double prevPointX = p1.x;
        double prevPointY = p1.y;
        double nextPointX = (double)p1.x + heightSinT;
        double nextPointY = (double)p1.y + heightCosT;
        Color currentColor = colors.get(0);
        int i = 0;
        this.g.setColor(currentColor);
        this.g.fillOval(p1.x - 9, p1.y - 9, 18, 18);
        if (colors.size() == 1) {
            int[] xPoints = new int[]{(int)((double)p1.x + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)((double)p1.x - cosT)};
            int[] yPoints = new int[]{(int)((double)p1.y - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)((double)p1.y + sinT)};
            this.g.setColor(currentColor);
            this.g.fillPolygon(xPoints, yPoints, 4);
        } else {
            boolean iterate = true;
            while (iterate) {
                currentColor = colors.get(i % colors.size());
                int[] xPoints = new int[]{(int)(prevPointX + cosT), (int)(nextPointX + cosT), (int)(nextPointX - cosT), (int)(prevPointX - cosT)};
                int[] yPoints = new int[]{(int)(prevPointY - sinT), (int)(nextPointY - sinT), (int)(nextPointY + sinT), (int)(prevPointY + sinT)};
                this.g.setColor(currentColor);
                this.g.fillPolygon(xPoints, yPoints, 4);
                prevPointX += heightSinT;
                prevPointY += heightCosT;
                nextPointX += heightSinT;
                nextPointY += heightCosT;
                ++i;
                if (!(p1.x < p2.x && nextPointX >= (double)p2.x) && (p1.x < p2.x || !(nextPointX <= (double)p2.x))) continue;
                iterate = false;
            }
            int[] lastXPoints = new int[]{(int)(prevPointX + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)(prevPointX - cosT)};
            int[] lastYPoints = new int[]{(int)(prevPointY - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)(prevPointY + sinT)};
            this.g.setColor(currentColor);
            this.g.fillPolygon(lastXPoints, lastYPoints, 4);
        }
        this.g.setColor(currentColor);
        this.g.fillOval(p2.x - 9, p2.y - 9, 18, 18);
    }

    private void drawFixVariantLetter(String letter, Color color, double letterX, double letterY) {
        this.g.setColor(color);
        Font stringFont = new Font("SansSerif", 0, 50);
        this.g.setFont(stringFont);
        try {
            this.g.drawString(letter, (int)letterX, (int)letterY);
            this.g.drawString(letter, (int)letterX, (int)letterY);
        }
        catch (NullPointerException ex) {
            Logging.trace((Throwable)ex);
        }
    }

    private static class RefTagComparator
    implements Comparator<String> {
        private RefTagComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null || s1.equals("") || s2 == null || s2.equals("")) {
                return 0;
            }
            String[] splitString1 = s1.split("\\D");
            String[] splitString2 = s2.split("\\D");
            if (splitString1.length == 0 && splitString2.length != 0) {
                return 1;
            }
            if (splitString1.length != 0 && splitString2.length == 0) {
                return -1;
            }
            if (splitString1.length == 0 && splitString2.length == 0) {
                return s1.compareTo(s2);
            }
            String firstNumberString1 = splitString1[0];
            String firstNumberString2 = splitString2[0];
            try {
                int firstNumber1 = Integer.parseInt(firstNumberString1);
                int firstNumber2 = Integer.parseInt(firstNumberString2);
                if (firstNumber1 > firstNumber2) {
                    return 1;
                }
                if (firstNumber1 < firstNumber2) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            catch (NumberFormatException ex) {
                return s1.compareTo(s2);
            }
        }
    }
}

