/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RemoveNodesCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.pt_assistant.actions.CreatePlatformNodeThroughReplaceAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtractPlatformNodeAction
extends JosmAction {
    public ExtractPlatformNodeAction() {
        super(I18n.tr((String)"Extract platform node", (Object[])new Object[0]), null, I18n.tr((String)"Extracts platform node from a node", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:extplatformnode", (String)"Tool: Extract platform node", (int)71, (int)5008), false);
        this.putValue("help", HelpUtil.ht((String)"/Action/ExtractPlatformNode"));
        MainApplication.registerActionShortcut((Action)((Object)this), (Shortcut)Shortcut.registerShortcut((String)"tools:extplatformnode", (String)"Tool: ExtractPlatformNodeAction", (int)71, (int)5008));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<ChangePropertyCommand> undoCommands;
        Way w;
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selection = ds.getSelected();
        List selectedNodes = OsmPrimitive.getFilteredList((Collection)selection, Node.class);
        if (selectedNodes.size() != 1) {
            new Notification(I18n.tr((String)"requires single node to be selected.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        Node nd = (Node)selectedNodes.get(0);
        boolean isNodeSuitable = false;
        if (nd.hasTag("highway") && (nd.hasTag("highway", "bus_stop") || nd.hasTag("public_transport", "stop_position"))) {
            isNodeSuitable = true;
        } else if (nd.hasTag("railway") && (nd.hasTag("railway", "tram_stop") || nd.hasTag("public_transport", "stop_position"))) {
            isNodeSuitable = true;
        }
        if (!isNodeSuitable) {
            return;
        }
        LinkedList<MoveCommand> cmds = new LinkedList<MoveCommand>();
        Point p = MainApplication.getMap().mapView.getMousePosition();
        if (p == null) {
            return;
        }
        List refs = nd.getReferrers();
        boolean isFirstLastNode = false;
        for (OsmPrimitive pr : refs) {
            if (!(pr instanceof Way) || !(w = (Way)pr).firstNode().equals((Object)nd) && !w.lastNode().equals((Object)nd)) continue;
            isFirstLastNode = true;
        }
        if (!isFirstLastNode) {
            cmds.add(new MoveCommand(nd, MainApplication.getMap().mapView.getLatLon(p.x, p.y)));
            for (OsmPrimitive pr : refs) {
                if (!(pr instanceof Way)) continue;
                w = (Way)pr;
                MainApplication.undoRedo.add((Command)new RemoveNodesCommand(w, Arrays.asList(nd)));
            }
        } else {
            Node newNode = new Node(MainApplication.getMap().mapView.getLatLon(p.x, p.y));
            MainApplication.undoRedo.add((Command)new AddCommand(this.getLayerManager().getEditDataSet(), (OsmPrimitive)newNode));
            MainApplication.undoRedo.add((Command)new ChangePropertyCommand(Collections.singleton(newNode), new HashMap(nd.getKeys())));
            CreatePlatformNodeThroughReplaceAction cpsa = new CreatePlatformNodeThroughReplaceAction();
            cpsa.modify(newNode, nd);
            return;
        }
        MainApplication.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Extract node from line", (Object[])new Object[0]), cmds));
        if (nd.hasTag("railway")) {
            undoCommands = new ArrayList<ChangePropertyCommand>();
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "public_transport", "platform"));
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "tram", "yes"));
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "railway", "tram_stop"));
            MainApplication.undoRedo.add((Command)new SequenceCommand("tag", undoCommands));
        } else if (nd.hasTag("highway")) {
            undoCommands = new ArrayList();
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "public_transport", "platform"));
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "bus", "yes"));
            undoCommands.add(new ChangePropertyCommand((OsmPrimitive)nd, "highway", "bus_stop"));
            MainApplication.undoRedo.add((Command)new SequenceCommand("tag", undoCommands));
        }
    }
}

