/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class EdgeSelectionAction
extends MapMode {
    private static final String MAP_MODE_NAME = "Edge Selection";
    private static final long serialVersionUID = 2414977774504904238L;
    private transient Set<Way> highlighted = new HashSet<Way>();
    private Cursor selectionCursor;
    private Cursor waySelectCursor;
    private List<Way> edgeList = new ArrayList<Way>();
    private String modeOfTravel = null;

    public EdgeSelectionAction() {
        super(I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), "edgeSelection", I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:edge_selection", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0])}), (int)75, (int)5006), ImageProvider.getCursor((String)"normal", (String)"selection"));
        this.selectionCursor = ImageProvider.getCursor((String)"normal", (String)"selection");
        this.waySelectCursor = ImageProvider.getCursor((String)"normal", (String)"select_way");
    }

    private List<Way> getEdgeFromWay(Way initial, String modeOfTravel) {
        List options;
        List<Way> edge = new ArrayList<Way>();
        if (!this.isWaySuitableForMode(initial, modeOfTravel).booleanValue()) {
            return edge;
        }
        Way curr = initial;
        while (true) {
            options = curr.firstNode(true).getParentWays();
            if (curr.firstNode().hasTag("public_transport", "stop_position")) break;
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        curr = initial;
        while (true) {
            options = curr.lastNode(true).getParentWays();
            if (curr.lastNode().hasTag("public_transport", "stop_position")) break;
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        edge.add(initial);
        edge = this.sortEdgeWays(edge);
        return edge;
    }

    private List<Way> sortEdgeWays(List<Way> edge) {
        List members = edge.stream().map(w -> new RelationMember("", (OsmPrimitive)w)).collect(Collectors.toList());
        List sorted = new RelationSorter().sortMembers(members);
        return sorted.stream().map(RelationMember::getWay).collect(Collectors.toList());
    }

    private Boolean isWaySuitableForMode(Way way, String modeOfTravel) {
        if ("bus".equals(modeOfTravel)) {
            return RouteUtils.isWaySuitableForBuses(way);
        }
        if ("bicycle".equals(modeOfTravel)) {
            if (way.hasTag("bicycle", "yes")) {
                return true;
            }
            if (way.hasTag("bicycle", "no") || way.hasTag("bicycle", "side_path")) {
                return false;
            }
            if (way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "footway") || way.hasTag("highway", "pedestrian")) {
                return false;
            }
            return true;
        }
        if ("foot".equals(modeOfTravel)) {
            return way.hasTag("highway", "footway") || !way.hasKey(new String[]{"highway", "motorway"}) && !way.hasKey(new String[]{"foot", "no"}) && !way.hasKey(new String[]{"foot", "use_sidepath"});
        }
        if ("horse".equals(modeOfTravel)) {
            return true;
        }
        if ("light_rail".equals(modeOfTravel)) {
            return way.hasTag("railway", "light_rail");
        }
        if ("railway".equals(modeOfTravel)) {
            return way.hasKey("railway");
        }
        if ("subway".equals(modeOfTravel)) {
            return way.hasTag("railway", "subway");
        }
        if ("train".equals(modeOfTravel)) {
            return way.hasTag("railway", "rail");
        }
        if ("tram".equals(modeOfTravel)) {
            return way.hasTag("railway", "tram");
        }
        if ("trolleybus".equals(modeOfTravel)) {
            return way.hasTag("trolley_wire", "yes");
        }
        return RouteUtils.isWaySuitableForPublicTransport(way);
    }

    private Way chooseBestWay(List<Way> ways, String modeOfTravel) {
        ways.removeIf(w -> this.isWaySuitableForMode((Way)w, modeOfTravel) == false);
        if (ways.isEmpty()) {
            return null;
        }
        if (ways.size() == 1) {
            return ways.get(0);
        }
        Way theChoosenOne = null;
        return theChoosenOne;
    }

    private String getModeOfTravel(Way initial) {
        List layers = MainApplication.getLayerManager().getLayers();
        for (Layer layer : layers) {
            PTAssistantLayer PTL;
            if (!layer.getName().equals("pt_assistant layer") || (PTL = (PTAssistantLayer)layer).getModeOfTravel() == null) continue;
            return PTL.getModeOfTravel();
        }
        return "bus";
    }

    public void mouseClicked(MouseEvent e) {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Way initial = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        this.updateKeyModifiers(e);
        if (!this.shift && !this.ctrl) {
            this.edgeList.clear();
            ds.clearSelection();
            if (initial != null) {
                this.modeOfTravel = this.getModeOfTravel(initial);
                List<Way> edge = this.getEdgeFromWay(initial, this.modeOfTravel);
                for (Way way : edge) {
                    if (this.edgeList.contains(way)) continue;
                    this.edgeList.add(way);
                }
                this.edgeList.addAll(edge);
                HashSet<Way> edgeSet = new HashSet<Way>(this.edgeList);
                new Notification(I18n.tr((String)"Mode of Travel -> {0} \n total ways selected -> {1}", (Object[])new Object[]{this.modeOfTravel, edgeSet.size()})).setIcon(1).setDuration(1200).show();
                ds.setSelected(this.edgeList);
                AutoScaleAction.zoomTo((Collection)edge.stream().map(w -> w).collect(Collectors.toList()));
            }
        } else if (!this.shift && this.ctrl && initial != null) {
            if (this.edgeList.size() == 0 || this.modeOfTravel == null) {
                this.modeOfTravel = this.getModeOfTravel(initial);
            }
            List<Way> edge = this.getEdgeFromWay(initial, this.modeOfTravel);
            ArrayList<Way> newEdges = new ArrayList<Way>();
            if (this.edgeList.containsAll(edge)) {
                for (Way way : edge) {
                    if (!this.edgeList.contains(way)) continue;
                    this.edgeList.remove(way);
                }
            } else {
                for (Way way : edge) {
                    if (this.edgeList.contains(way)) continue;
                    this.edgeList.add(way);
                    newEdges.addAll(this.findNewEdges(way, edge, this.edgeList));
                }
                if (newEdges != null) {
                    List<Way> waysToBeRemoved = this.waysToBeRemoved(newEdges);
                    if (waysToBeRemoved != null) {
                        newEdges.removeAll(waysToBeRemoved);
                    }
                    this.edgeList.addAll(newEdges);
                }
            }
            ds.clearSelection();
            HashSet<Way> edgeSet = new HashSet<Way>(this.edgeList);
            new Notification(I18n.tr((String)"Mode of Travel -> {0} \n total ways selected -> {1}", (Object[])new Object[]{this.modeOfTravel, edgeSet.size()})).setIcon(1).setDuration(900).show();
            ds.setSelected(this.edgeList);
            AutoScaleAction.zoomTo((Collection)edge.stream().map(w -> w).collect(Collectors.toList()));
        } else if (this.shift && !this.ctrl && initial != null) {
            if (this.edgeList.size() == 0 || this.modeOfTravel == null) {
                this.modeOfTravel = this.getModeOfTravel(initial);
            }
            if (initial != null) {
                List<Way> edge = this.getEdgeFromWay(initial, this.modeOfTravel);
                ArrayList<Way> newEdges = new ArrayList<Way>();
                for (Way way : edge) {
                    if (this.edgeList.contains(way)) continue;
                    this.edgeList.add(way);
                    newEdges.addAll(this.findNewEdges(way, edge, this.edgeList));
                }
                if (newEdges != null) {
                    List<Way> waysToBeRemoved = this.waysToBeRemoved(newEdges);
                    if (waysToBeRemoved != null) {
                        newEdges.removeAll(waysToBeRemoved);
                    }
                    this.edgeList.addAll(newEdges);
                }
                HashSet<Way> edgeSet = new HashSet<Way>(this.edgeList);
                new Notification(I18n.tr((String)"Mode of Travel -> {0} \n total ways selected -> {1}", (Object[])new Object[]{this.modeOfTravel, edgeSet.size()})).setIcon(1).setDuration(900).show();
                ds.setSelected(this.edgeList);
                AutoScaleAction.zoomTo((Collection)edge.stream().map(w -> w).collect(Collectors.toList()));
            }
        }
    }

    private List<Way> waysToBeRemoved(List<Way> newEdges) {
        ArrayList<Way> waysToBeRemoved = new ArrayList<Way>();
        for (int i = 0; i < newEdges.size(); ++i) {
            Node node1 = newEdges.get(i).firstNode();
            Node node2 = newEdges.get(i).lastNode();
            for (int j = i + 1; j < newEdges.size(); ++j) {
                if (newEdges.get(i).equals((Object)newEdges.get(j))) continue;
                Node node3 = newEdges.get(j).firstNode();
                Node node4 = newEdges.get(j).lastNode();
                if (node1.equals((Object)node3) && node2.equals((Object)node4)) {
                    if (!waysToBeRemoved.contains(newEdges.get(i))) {
                        waysToBeRemoved.add(newEdges.get(i));
                    }
                    if (waysToBeRemoved.contains(newEdges.get(j))) continue;
                    waysToBeRemoved.add(newEdges.get(j));
                    continue;
                }
                if (!node1.equals((Object)node4) || !node2.equals((Object)node3)) continue;
                if (!waysToBeRemoved.contains(newEdges.get(i))) {
                    waysToBeRemoved.add(newEdges.get(i));
                }
                if (waysToBeRemoved.contains(newEdges.get(j))) continue;
                waysToBeRemoved.add(newEdges.get(j));
            }
        }
        return waysToBeRemoved;
    }

    private List<Way> findNewEdges(Way way, List<Way> edge, List<Way> edgeList) {
        ArrayList<Way> newEdges = new ArrayList<Way>();
        Node firstNode = way.firstNode();
        Node lastNode = way.lastNode();
        List parentWayList1 = firstNode.getParentWays();
        parentWayList1.removeAll(edgeList);
        parentWayList1.removeAll(edge);
        List parentWayList2 = lastNode.getParentWays();
        parentWayList2.removeAll(edgeList);
        parentWayList2.removeAll(edge);
        parentWayList1.addAll(parentWayList2);
        for (Way parentWay : parentWayList1) {
            if (edge.contains(parentWay) || edgeList.contains(parentWay)) continue;
            Node node1 = parentWay.firstNode();
            Node node2 = parentWay.lastNode();
            for (Way oldWay : edgeList) {
                if (oldWay.equals((Object)way) || (!oldWay.containsNode(node1) || way.containsNode(node1)) && (!oldWay.containsNode(node2) || way.containsNode(node2))) continue;
                newEdges.add(parentWay);
            }
        }
        return newEdges;
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        for (Way way : this.highlighted) {
            way.setHighlighted(false);
        }
        this.highlighted.clear();
        Way initial = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        if (initial == null) {
            MainApplication.getMap().mapView.setCursor(this.selectionCursor);
        } else {
            MainApplication.getMap().mapView.setCursor(this.waySelectCursor);
            this.highlighted.addAll(this.getEdgeFromWay(initial, this.modeOfTravel));
        }
        for (Way way : this.highlighted) {
            way.setHighlighted(true);
        }
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }
}

