/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;

public class DoubleSplitAction
extends MapMode
implements KeyListener {
    private static final String MAP_MODE_NAME = "Double Split";
    private transient Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private List<Node> atNodes = new ArrayList<Node>();
    private final DoubleSplitLayer temporaryLayer = new DoubleSplitLayer();
    ILatLon Pos1 = null;
    ILatLon Pos2 = null;
    Way SegWay1 = null;
    Way SegWay2 = null;
    Way affected;
    Way previousAffectedWay;
    private final Cursor cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
    private final Cursor cursorJoinWay = ImageProvider.getCursor((String)"crosshair", (String)"joinway");

    public DoubleSplitAction() {
        super(I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), "logo_double_split", I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), null, DoubleSplitAction.getCursor());
    }

    private static Cursor getCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(1);
        return cursor;
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getMap().mapView.addKeyListener((KeyListener)this);
        MainApplication.getMap().mapView.addTemporaryLayer((MapViewPaintable)this.temporaryLayer);
    }

    public void exitMode() {
        this.reset();
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getMap().mapView.removeKeyListener((KeyListener)this);
        MainApplication.getMap().mapView.removeTemporaryLayer((MapViewPaintable)this.temporaryLayer);
        this.resetLayer();
    }

    private void reset() {
        try {
            this.atNodes.clear();
            this.updateHighlights();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("reset");
    }

    private void resetLayer() {
        this.Pos1 = null;
        this.Pos2 = null;
        this.SegWay1 = null;
        this.SegWay2 = null;
        this.temporaryLayer.invalidate();
    }

    private boolean startEndPoints(List<Command> commandList) {
        try {
            for (Way way : this.atNodes.get(0).getParentWays()) {
                if (!this.atNodes.get(1).getParentWays().contains(way) || !way.isFirstLastNode(this.atNodes.get(0)) || !way.isFirstLastNode(this.atNodes.get(1))) continue;
                ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
                affectedKeysList.add(way.getKeys());
                this.newHighlights.add((OsmPrimitive)way);
                this.dialogBox(3, null, way, way, commandList);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean firstNodeIsConnectionNode(Node node, Way affected, Way previousAffectedWay) {
        if (node.isConnectionNode()) {
            if (node.getParentWays().contains(affected)) {
                previousAffectedWay = affected;
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean secondNodeIsConnectionNode(Node node, Way previousAffectedWay) {
        if (this.atNodes.get(1).isConnectionNode()) {
            return !this.atNodes.get(1).getParentWays().contains(previousAffectedWay);
        }
        return false;
    }

    private Node checkCommonNode(Way affected, Way previousAffectedWay) {
        List presentNodeList = affected.getNodes();
        for (Node previousNode : previousAffectedWay.getNodes()) {
            if (!presentNodeList.contains(previousNode)) continue;
            return previousNode;
        }
        return null;
    }

    private void removeFirstNode() {
        this.atNodes.get(0).setDeleted(true);
        this.atNodes.get(1).setDeleted(true);
        this.Pos1 = this.Pos2;
        this.Pos2 = null;
        this.SegWay1 = this.SegWay2;
        this.SegWay2 = null;
        this.reset();
    }

    private void action() {
        ArrayList<Command> commandList = new ArrayList<Command>();
        Point curP1 = MainApplication.getMap().mapView.getPoint(this.Pos1);
        LatLon P1 = new LatLon(curP1.getX(), curP1.getY());
        Node node1 = this.createNode((ILatLon)P1, commandList);
        if (node1 == null) {
            this.resetLayer();
            this.reset();
            return;
        }
        Point curP2 = MainApplication.getMap().mapView.getPoint(this.Pos2);
        LatLon P2 = new LatLon(curP2.getX(), curP2.getY());
        Node node2 = this.createNode((ILatLon)P2, commandList);
        if (node2 == null) {
            node1.setDeleted(true);
            this.Pos2 = null;
            this.SegWay2 = null;
            this.reset();
            return;
        }
        if (node1.equals((Object)node2)) {
            this.resetLayer();
            System.out.println("same");
            return;
        }
        this.atNodes.add(node1);
        this.atNodes.add(node2);
        this.previousAffectedWay = this.SegWay1;
        this.affected = this.SegWay2;
        if (this.affected == null || this.previousAffectedWay == null) {
            node1.setDeleted(true);
            node2.setDeleted(true);
            this.resetLayer();
            return;
        }
        boolean areStartEndPoints = this.startEndPoints(commandList);
        if (areStartEndPoints) {
            this.resetLayer();
            return;
        }
        boolean isConnectionNode = this.firstNodeIsConnectionNode(this.atNodes.get(0), this.affected, this.previousAffectedWay);
        if (isConnectionNode) {
            this.resetLayer();
            return;
        }
        isConnectionNode = this.secondNodeIsConnectionNode(this.atNodes.get(1), this.previousAffectedWay);
        if (isConnectionNode) {
            this.resetLayer();
            return;
        }
        if (this.atNodes.get(1).isConnectionNode()) {
            this.affected = this.previousAffectedWay;
        }
        Node commonNode = null;
        boolean twoWaysWithCommonNode = false;
        if (this.previousAffectedWay != this.affected) {
            commonNode = this.checkCommonNode(this.affected, this.previousAffectedWay);
            if (commonNode == null) {
                this.removeFirstNode();
                return;
            }
            twoWaysWithCommonNode = true;
        }
        if (twoWaysWithCommonNode) {
            this.dialogBox(1, commonNode, this.affected, this.previousAffectedWay, commandList);
        } else {
            this.dialogBox(2, commonNode, this.affected, this.previousAffectedWay, commandList);
        }
    }

    private void dialogBox(int type, Node commonNode, Way affected, Way previousAffectedWay, List<Command> commandList) {
        SelectFromOptionDialog dialog = new SelectFromOptionDialog(type, commonNode, affected, previousAffectedWay, commandList, this.atNodes);
        dialog.setModal(false);
        dialog.showDialog();
    }

    private Node createNode(ILatLon Pos, List<Command> commandList) {
        Node newStopPos;
        Boolean newNode = false;
        Point p = new Point();
        p.setLocation(Pos.lat(), Pos.lon());
        Node n = MainApplication.getMap().mapView.getNearestNode(p, AbstractPrimitive::isUsable);
        if (n == null) {
            newNode = true;
            newStopPos = new Node(MainApplication.getMap().mapView.getLatLon(Pos.lat(), Pos.lon()));
        } else {
            newStopPos = new Node(n);
        }
        if (newNode.booleanValue()) {
            commandList.add((Command)new AddCommand(this.getLayerManager().getEditDataSet(), (OsmPrimitive)newStopPos));
        } else {
            commandList.add((Command)new ChangeCommand((OsmPrimitive)n, (OsmPrimitive)newStopPos));
            MainApplication.getLayerManager().getEditLayer().data.setSelected(new PrimitiveId[]{newStopPos});
            newStopPos = n;
        }
        return newStopPos;
    }

    private void addKeys(Way affected, List<Command> commandList, JComboBox<String> keys, JComboBox<String> values) {
        ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
        Way selectedWay = null;
        MainApplication.undoRedo.add((Command)new SequenceCommand("Add Nodes", commandList));
        commandList.clear();
        this.addParentWay(this.atNodes.get(0));
        this.addParentWay(this.atNodes.get(1));
        SplitWayCommand result = SplitWayCommand.split((Way)affected, this.atNodes, Collections.emptyList());
        if (result == null) {
            MainApplication.undoRedo.undo();
            this.resetLayer();
            return;
        }
        commandList.add((Command)result);
        MainApplication.undoRedo.add((Command)new SequenceCommand("Split Way", commandList));
        List affectedWayList = result.getNewWays();
        affectedWayList.add(result.getOriginalWay());
        for (Way way : affectedWayList) {
            if (!this.atNodes.contains(way.firstNode()) || !this.atNodes.contains(way.lastNode())) continue;
            selectedWay = way;
            break;
        }
        if (selectedWay == null) {
            MainApplication.undoRedo.undo();
            MainApplication.undoRedo.undo();
            this.resetLayer();
            return;
        }
        affectedKeysList.add(affected.getKeys());
        this.addTags(affectedKeysList, Arrays.asList(selectedWay), keys, values, 0);
    }

    private void addKeysOnBothWays(Node commonNode, Way affected, Way previousAffectedWay, List<Command> commandList, JComboBox<String> keys, JComboBox<String> values) {
        Object way;
        ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
        MainApplication.undoRedo.add((Command)new SequenceCommand("Add Nodes", commandList));
        commandList.clear();
        this.addParentWay(this.atNodes.get(0));
        this.addParentWay(this.atNodes.get(1));
        List<Node> nodelist1 = Arrays.asList(this.atNodes.get(0), commonNode);
        List<Node> nodelist2 = Arrays.asList(this.atNodes.get(1), commonNode);
        affectedKeysList.add(previousAffectedWay.getKeys());
        affectedKeysList.add(affected.getKeys());
        SplitWayCommand result1 = SplitWayCommand.split((Way)previousAffectedWay, nodelist1, Collections.emptyList());
        SplitWayCommand result2 = SplitWayCommand.split((Way)affected, nodelist2, Collections.emptyList());
        if (result1 == null) {
            MainApplication.undoRedo.undo();
            this.resetLayer();
            return;
        }
        commandList.add((Command)result1);
        if (result2 == null) {
            MainApplication.undoRedo.undo();
            this.resetLayer();
            return;
        }
        commandList.add((Command)result2);
        MainApplication.undoRedo.add((Command)new SequenceCommand("Split Way", commandList));
        List referrers1 = OsmPrimitive.getFilteredList((Collection)previousAffectedWay.getReferrers(), Relation.class);
        referrers1.removeIf(r -> !RouteUtils.isPTRoute(r));
        int Index1 = this.getIndex(previousAffectedWay, referrers1, previousAffectedWay);
        List referrers2 = OsmPrimitive.getFilteredList((Collection)affected.getReferrers(), Relation.class);
        referrers2.removeIf(r -> !RouteUtils.isPTRoute(r));
        int Index2 = this.getIndex(affected, referrers2, previousAffectedWay);
        Object way1 = null;
        Object way2 = null;
        boolean isOriginalWay = true;
        for (Way way3 : result1.getNewWays()) {
            this.checkMembership(way3, referrers1, Index1);
            if (!way3.containsNode(commonNode) || !way3.containsNode(this.atNodes.get(0))) continue;
            way1 = way3;
            isOriginalWay = false;
            break;
        }
        this.checkMembership(result1.getOriginalWay(), referrers1, Index1);
        if (isOriginalWay && (way = result1.getOriginalWay()).containsNode(commonNode) && way.containsNode(this.atNodes.get(0))) {
            way1 = way;
        }
        isOriginalWay = true;
        way = result2.getNewWays().iterator();
        while (way.hasNext()) {
            Way way3;
            way3 = (Way)way.next();
            this.checkMembership(way3, referrers2, Index2);
            if (!way3.containsNode(commonNode) || !way3.containsNode(this.atNodes.get(1))) continue;
            way2 = way3;
            isOriginalWay = false;
            break;
        }
        this.checkMembership(result2.getOriginalWay(), referrers2, Index2);
        if (isOriginalWay && (way = result2.getOriginalWay()).containsNode(commonNode) && way.containsNode(this.atNodes.get(1))) {
            way2 = way;
        }
        if (way1 != null && way2 != null) {
            List<Way> selectedWays = Arrays.asList(way1, way2);
            this.addTags(affectedKeysList, selectedWays, keys, values, 1);
        } else {
            MainApplication.undoRedo.undo();
            MainApplication.undoRedo.undo();
            this.resetLayer();
        }
    }

    private void addKeysWhenStartEndPoint(Way affected, List<Command> commandList, JComboBox<String> keys, JComboBox<String> values) {
        ArrayList<TagMap> affectedKeysList = new ArrayList<TagMap>();
        Way selectedWay = affected;
        this.addParentWay(this.atNodes.get(0));
        this.addParentWay(this.atNodes.get(1));
        if (selectedWay != null) {
            affectedKeysList.add(affected.getKeys());
            this.addTags(affectedKeysList, Arrays.asList(selectedWay), keys, values, 2);
        } else {
            this.resetLayer();
        }
    }

    private void addParentWay(Node node) {
        if (node.getParentWays().size() == 0) {
            MainApplication.getLayerManager().getEditLayer().data.setSelected(new PrimitiveId[]{node});
            JoinNodeWayAction joinNodeWayAction = JoinNodeWayAction.createMoveNodeOntoWayAction();
            joinNodeWayAction.actionPerformed(null);
        }
    }

    private void checkMembership(Way way, List<Relation> referrers, int Index) {
        for (Relation r : referrers) {
            boolean isMember = false;
            for (RelationMember rm : r.getMembers()) {
                if (rm.getType() != OsmPrimitiveType.WAY || !rm.getWay().equals((Object)way)) continue;
                isMember = true;
            }
            if (isMember) continue;
            r.addMember(new RelationMember("", (OsmPrimitive)way));
        }
    }

    private int getIndex(Way way, List<Relation> referrers, Way previousAffectedWay) {
        int Index = -1;
        for (Relation r : referrers) {
            for (int i = 0; i < r.getMembers().size(); ++i) {
                if (!((RelationMember)r.getMembers().get(i)).isWay() || !((RelationMember)r.getMembers().get(i)).getWay().equals((Object)previousAffectedWay)) continue;
                Index = i;
            }
        }
        return Index;
    }

    private void addTags(List<TagMap> affectedKeysList, List<Way> selectedWay, JComboBox<String> keys, JComboBox<String> values, int type) {
        TagMap newKeys1 = affectedKeysList.get(0);
        String prevValue = null;
        if (keys.getSelectedItem() == "bridge") {
            newKeys1.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
            newKeys1.put("layer", "1");
        } else if (keys.getSelectedItem() == "tunnel") {
            newKeys1.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
            if (!values.getSelectedItem().toString().equals("building_passage")) {
                newKeys1.put("layer", "-1");
            }
        } else if (newKeys1.containsKey((Object)"bus_bay")) {
            prevValue = newKeys1.get((Object)"bus_bay");
            newKeys1.put(keys.getSelectedItem().toString(), "both");
        } else {
            newKeys1.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
        }
        if (affectedKeysList.size() == 2) {
            TagMap newKeys2 = affectedKeysList.get(1);
            if (keys.getSelectedItem() == "bridge") {
                newKeys2.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
                newKeys2.put("layer", "1");
            } else if (keys.getSelectedItem() == "tunnel") {
                newKeys2.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
                if (!values.getSelectedItem().toString().equals("building_passage")) {
                    newKeys2.put("layer", "-1");
                }
            } else if (newKeys2.containsKey((Object)"bus_bay")) {
                prevValue = newKeys2.get((Object)"bus_bay");
                newKeys2.put(keys.getSelectedItem().toString(), "both");
                if (values.getSelectedItem().equals("left") && prevValue.equals("left")) {
                    newKeys1.put("bus_bay", "right");
                } else if (values.getSelectedItem().equals("right") && prevValue.equals("right")) {
                    newKeys1.put("bus_bay", "left");
                }
            } else if (newKeys1.get((Object)"bus_bay").equals("both")) {
                if (values.getSelectedItem().equals("left") && prevValue.equals("left")) {
                    newKeys2.put("bus_bay", "right");
                } else if (values.getSelectedItem().equals("right") && prevValue.equals("right")) {
                    newKeys2.put("bus_bay", "left");
                } else {
                    newKeys2.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
                }
            } else {
                newKeys2.put(keys.getSelectedItem().toString(), values.getSelectedItem().toString());
            }
            MainApplication.undoRedo.add((Command)new ChangePropertyCommand(Collections.singleton(selectedWay.get(1)), (Map)newKeys2));
        }
        MainApplication.undoRedo.add((Command)new ChangePropertyCommand(Collections.singleton(selectedWay.get(0)), (Map)newKeys1));
        this.resetLayer();
    }

    private void findIntersection(Set<Way> newWays) {
        try {
            DataSet ds = this.getLayerManager().getEditDataSet();
            this.addWaysIntersectingWays(ds.getWays(), Arrays.asList(this.previousAffectedWay, this.affected), newWays);
            Node n1 = this.previousAffectedWay.firstNode();
            Node n2 = this.previousAffectedWay.lastNode();
            Node n3 = this.affected.firstNode();
            Node n4 = this.affected.lastNode();
            ArrayList<Way> waysToBeRemoved = new ArrayList<Way>();
            for (Way way : newWays) {
                int count = 0;
                if (way.containsNode(n1)) {
                    ++count;
                }
                if (way.containsNode(n2)) {
                    ++count;
                }
                if (!this.previousAffectedWay.equals((Object)this.affected)) {
                    if (way.containsNode(n3)) {
                        ++count;
                    }
                    if (way.containsNode(n4)) {
                        ++count;
                    }
                }
                if (count == 1) {
                    waysToBeRemoved.add(way);
                    continue;
                }
                if (way.hasKey("highway") || way.hasKey("waterway") || way.hasKey("railway")) continue;
                waysToBeRemoved.add(way);
            }
            newWays.removeAll(waysToBeRemoved);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addWaysIntersectingWay(Collection<Way> ways, Way w, Set<Way> newWays) {
        List nodePairs = w.getNodePairs(false);
        block0: for (Way anyway : ways) {
            if (Objects.equals(anyway, w) || newWays.contains(anyway)) continue;
            List nodePairs2 = anyway.getNodePairs(false);
            for (Pair p1 : nodePairs) {
                for (Pair p2 : nodePairs2) {
                    if (null == Geometry.getSegmentSegmentIntersection((EastNorth)((Node)p1.a).getEastNorth(), (EastNorth)((Node)p1.b).getEastNorth(), (EastNorth)((Node)p2.a).getEastNorth(), (EastNorth)((Node)p2.b).getEastNorth())) continue;
                    newWays.add(anyway);
                    continue block0;
                }
            }
        }
    }

    void addWaysIntersectingWays(Collection<Way> allWays, Collection<Way> initWays, Set<Way> newWays) {
        for (Way w : initWays) {
            this.addWaysIntersectingWay(allWays, w, newWays);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Cursor newCurs = DoubleSplitAction.getCursor();
        Node n = MainApplication.getMap().mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
        if (n != null) {
            this.newHighlights.add((OsmPrimitive)n);
            newCurs = this.cursorJoinNode;
        } else {
            List wss = MainApplication.getMap().mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive::isSelectable);
            if (!wss.isEmpty()) {
                for (WaySegment ws : wss) {
                    this.newHighlights.add((OsmPrimitive)ws.way);
                }
                newCurs = this.cursorJoinWay;
            }
        }
        MainApplication.getMap().mapView.setCursor(newCurs);
        this.updateHighlights();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.Pos1 == null) {
            this.SegWay1 = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), OsmPrimitive::isSelectable);
            if (this.SegWay1 != null) {
                this.Pos1 = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
            }
        } else if (this.Pos2 == null) {
            LatLon tempPos = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
            if (this.Pos1.lat() != tempPos.lat() || this.Pos1.lon() != tempPos.lon()) {
                this.SegWay2 = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), OsmPrimitive::isSelectable);
                if (this.SegWay2 != null) {
                    this.Pos2 = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
                }
            }
        }
        if (this.Pos2 != null) {
            this.reset();
            this.action();
        }
    }

    private void updateHighlights() {
        if (this.oldHighlights == null && this.newHighlights == null) {
            return;
        }
        if (this.oldHighlights.isEmpty() && this.newHighlights.isEmpty()) {
            return;
        }
        for (OsmPrimitive osm : this.oldHighlights) {
            osm.setHighlighted(false);
        }
        for (OsmPrimitive osm : this.newHighlights) {
            osm.setHighlighted(true);
        }
        MainApplication.getLayerManager().getEditLayer().invalidate();
        this.oldHighlights.clear();
        this.oldHighlights.addAll(this.newHighlights);
        this.newHighlights.clear();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        System.out.println("keyTyped");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        System.out.println("keyPressed");
        boolean z = e.getKeyCode() == 90;
        this.updateKeyModifiers(e);
        if (z && this.Pos1 != null && this.Pos2 == null) {
            this.Pos1 = null;
            this.SegWay1 = null;
            this.temporaryLayer.invalidate();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        System.out.println("keyReleased");
    }

    private class DoubleSplitLayer
    extends AbstractMapViewPaintable {
        private DoubleSplitLayer() {
        }

        public void paint(Graphics2D g, MapView mv, Bounds bbox) {
            if (DoubleSplitAction.this.Pos1 != null) {
                Point curP1 = MainApplication.getMap().mapView.getPoint(DoubleSplitAction.this.Pos1);
                CheckParameterUtil.ensureParameterNotNull((Object)mv, (String)"mv");
                g.setColor(Color.RED);
                g.fill(new Rectangle2D.Double(curP1.x - 3, curP1.y - 3, 6.0, 6.0));
            }
            if (DoubleSplitAction.this.Pos2 != null) {
                Point curP2 = MainApplication.getMap().mapView.getPoint(DoubleSplitAction.this.Pos2);
                CheckParameterUtil.ensureParameterNotNull((Object)mv, (String)"mv");
                g.setColor(Color.RED);
                g.fill(new Rectangle2D.Double(curP2.x - 3, curP2.y - 3, 6.0, 6.0));
            }
        }
    }

    private class SelectFromOptionDialog
    extends ExtendedDialog {
        Way affected;
        Way previousAffectedWay;
        private JComboBox<String> keys;
        private JComboBox<String> values;
        private int type;
        private List<Command> commandList;
        private Node commonNode;
        private boolean rightHandTraffic;

        SelectFromOptionDialog(int type, Node commonNode, Way affected, Way previousAffectedWay, List<Command> commandList, List<Node> atNode) {
            super(Main.parent, I18n.tr((String)"What do you want the segment to be?", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
            this.affected = affected;
            this.previousAffectedWay = previousAffectedWay;
            this.commandList = commandList;
            this.type = type;
            this.commonNode = commonNode;
            this.rightHandTraffic = true;
            for (Node n : DoubleSplitAction.this.atNodes) {
                if (RightAndLefthandTraffic.isRightHandTraffic((LatLon)n.getCoor())) continue;
                this.rightHandTraffic = false;
                break;
            }
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(new Integer[]{2});
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)new JLabel("Select the appropriate option"), GBC.eol().fill(2));
            this.keys = new JComboBox();
            this.values = new JComboBox();
            this.keys.setEditable(true);
            HashSet newWays = new HashSet();
            DoubleSplitAction.this.findIntersection(newWays);
            if (previousAffectedWay.hasKey("waterway") || affected.hasKey("waterway")) {
                this.setOptionsWithTunnel();
            } else if (previousAffectedWay.hasKey("bus_bay") || affected.hasKey("bus_bay")) {
                this.setOptionsWithBusBay();
            } else if (newWays != null && newWays.size() != 0) {
                this.setOptionsWithBridge();
            } else {
                this.setOptionsWithBusBay();
            }
            pane.add(this.keys, GBC.eop().fill(2));
            pane.add(this.values, GBC.eop().fill(2));
            this.setContent(pane, false);
            this.setDefaultCloseOperation(1);
        }

        private void setOptionsWithBusBay() {
            this.keys.setModel(new DefaultComboBoxModel<String>(new String[]{"bus_bay", "bridge", "tunnel"}));
            if (this.affected.hasTag("bus_bay", "right") || this.previousAffectedWay.hasTag("bus_bay", "right")) {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "right", "both"}));
            } else if (this.affected.hasTag("bus_bay", "left") || this.previousAffectedWay.hasTag("bus_bay", "left")) {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"right", "left", "both"}));
            } else if (this.rightHandTraffic) {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"right", "left", "both"}));
            } else {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "right", "both"}));
            }
            this.keys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("bus_bay".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"both", "right", "left"}));
                        if (SelectFromOptionDialog.this.rightHandTraffic) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"right", "left", "both"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "right", "both"}));
                        }
                    } else if ("bridge".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes"}));
                    } else if ("tunnel".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        if (SelectFromOptionDialog.this.previousAffectedWay.hasKey("waterway") || SelectFromOptionDialog.this.affected.hasKey("waterway")) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"culvert", "yes", "building_passage"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "culvert", "building_passage"}));
                        }
                    }
                }
            });
        }

        private void setOptionsWithTunnel() {
            this.keys.setModel(new DefaultComboBoxModel<String>(new String[]{"tunnel", "bridge", "bus_bay"}));
            if (this.previousAffectedWay.hasKey("waterway") || this.affected.hasKey("waterway")) {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"culvert", "yes", "building_passage"}));
            } else {
                this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "culvert", "building_passage"}));
            }
            this.keys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("tunnel".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        if (SelectFromOptionDialog.this.previousAffectedWay.hasKey("waterway") || SelectFromOptionDialog.this.affected.hasKey("waterway")) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"culvert", "yes", "building_passage"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "culvert", "building_passage"}));
                        }
                    } else if ("bus_bay".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"both", "right", "left"}));
                        if (SelectFromOptionDialog.this.rightHandTraffic) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"right", "left", "both"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "right", "both"}));
                        }
                    } else if ("bridge".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes"}));
                    }
                }
            });
        }

        private void setOptionsWithBridge() {
            this.keys.setModel(new DefaultComboBoxModel<String>(new String[]{"bridge", "bus_bay", "tunnel"}));
            this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes"}));
            this.keys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("tunnel".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        if (SelectFromOptionDialog.this.previousAffectedWay.hasKey("waterway") || SelectFromOptionDialog.this.affected.hasKey("waterway")) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"culvert", "yes", "building_passage"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "culvert", "building_passage"}));
                        }
                    } else if ("bus_bay".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"both", "right", "left"}));
                        if (SelectFromOptionDialog.this.rightHandTraffic) {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"right", "left", "both"}));
                        } else {
                            SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "right", "both"}));
                        }
                    } else if ("bridge".equals(SelectFromOptionDialog.this.keys.getSelectedItem())) {
                        SelectFromOptionDialog.this.values.setModel(new DefaultComboBoxModel<String>(new String[]{"yes"}));
                    }
                }
            });
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            super.buttonAction(buttonIndex, evt);
            this.toggleSaveState();
            if (this.getValue() == 1) {
                if (this.type == 1) {
                    DoubleSplitAction.this.addKeysOnBothWays(this.commonNode, this.affected, this.previousAffectedWay, this.commandList, this.keys, this.values);
                } else if (this.type == 2) {
                    DoubleSplitAction.this.addKeys(this.affected, this.commandList, this.keys, this.values);
                } else if (this.type == 3) {
                    DoubleSplitAction.this.addKeysWhenStartEndPoint(this.affected, this.commandList, this.keys, this.values);
                }
            } else if (this.getValue() != 3) {
                DoubleSplitAction.this.resetLayer();
            }
        }
    }
}

