/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.datatransfer.PrimitiveTransferable;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;

public class CreatePlatformNodeThroughReplaceAction
extends JosmAction {
    private static final String ACTION_NAME = "Shortcut action to Transfer details of stop to platform node";
    protected final OsmTransferHandler transferHandler = new OsmTransferHandler();

    public CreatePlatformNodeThroughReplaceAction() {
        super(ACTION_NAME, null, ACTION_NAME, Shortcut.registerShortcut((String)"tools:createplatformthruoghreplace", (String)"Tool: CreatePlatformNodeThroughReplaceAction", (int)71, (int)5005), false);
        MainApplication.registerActionShortcut((Action)((Object)this), (Shortcut)Shortcut.registerShortcut((String)"tools:createplatformthruoghreplace", (String)"Tool: CreatePlatformNodeThroughReplaceAction", (int)71, (int)5005));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        Node stopPositionNode = null;
        Node newNode = null;
        for (OsmPrimitive item : selection) {
            if (item.getType() != OsmPrimitiveType.NODE) continue;
            if (item.hasTag("highway") && (item.hasTag("highway", "bus_stop") || item.hasTag("public_transport", "stop_position"))) {
                stopPositionNode = (Node)item;
                continue;
            }
            if (!item.hasTag("railway") || !item.hasTag("railway", "tram_stop") && !item.hasTag("public_transport", "stop_position")) continue;
            stopPositionNode = (Node)item;
        }
        if (stopPositionNode != null && selection.size() == 1) {
            PrimitiveTransferData data = PrimitiveTransferData.getDataWithReferences((Collection)selection);
            this.transferHandler.pasteOn(this.getLayerManager().getEditLayer(), this.computePastePosition(e), (Transferable)new PrimitiveTransferable(data));
            Collection newSelection = this.getLayerManager().getEditDataSet().getSelected();
            for (OsmPrimitive item : newSelection) {
                newNode = (Node)item;
            }
        }
        if (newNode != null) {
            this.modify(newNode, stopPositionNode);
        }
    }

    protected EastNorth computePastePosition(ActionEvent e) {
        PointerInfo pointerInfo;
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth mPosition = mapView.getCenter();
        if (e != null && !this.getValue("Name").equals(e.getActionCommand()) && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            Point mp = pointerInfo.getLocation();
            Point tl = mapView.getLocationOnScreen();
            Point pos = new Point(mp.x - tl.x, mp.y - tl.y);
            if (mapView.contains(pos)) {
                mPosition = mapView.getEastNorth(pos.x, pos.y);
            }
        }
        return mPosition;
    }

    public void modify(Node newNode, Node stopPositionNode) {
        if (stopPositionNode.hasTag("railway")) {
            newNode.put("tram", "yes");
            newNode.put("railway", "tram_stop");
            newNode.remove("public_transport");
            newNode.put("public_transport", "platform");
            List<Command> commands = CreatePlatformNodeThroughReplaceAction.getReplaceGeometryCommand((OsmPrimitive)stopPositionNode, (OsmPrimitive)newNode);
            if (commands.size() > 0) {
                MainApplication.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace Membership", (Object[])new Object[0]), commands));
            }
            HashMap<String, String> tags = new HashMap<String, String>((Map<String, String>)stopPositionNode.getKeys());
            tags.replaceAll((key, value) -> null);
            MainApplication.undoRedo.add((Command)new ChangePropertyCommand(Collections.singleton(stopPositionNode), tags));
        } else if (stopPositionNode.hasTag("highway")) {
            newNode.put("bus", "yes");
            newNode.put("highway", "bus_stop");
            newNode.remove("public_transport");
            newNode.put("public_transport", "platform");
            List<Command> commands = CreatePlatformNodeThroughReplaceAction.getReplaceGeometryCommand((OsmPrimitive)stopPositionNode, (OsmPrimitive)newNode);
            if (commands.size() > 0) {
                MainApplication.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace Membership", (Object[])new Object[0]), commands));
            }
            HashMap<String, String> tags = new HashMap<String, String>((Map<String, String>)stopPositionNode.getKeys());
            tags.replaceAll((key, value) -> null);
            MainApplication.undoRedo.add((Command)new ChangePropertyCommand(Collections.singleton(stopPositionNode), tags));
        }
    }

    static List<Command> getReplaceGeometryCommand(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        MultiMap byRelation = new MultiMap();
        for (RelationToChildReference i : RelationToChildReference.getRelationToChildReferences((OsmPrimitive)firstObject)) {
            byRelation.put((Object)i.getParent(), (Object)i);
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry i : byRelation.entrySet()) {
            Relation oldRelation = (Relation)i.getKey();
            Relation newRelation = new Relation(oldRelation);
            for (RelationToChildReference reference : (Set)i.getValue()) {
                newRelation.setMember(reference.getPosition(), new RelationMember("platform", secondObject));
            }
            commands.add((Command)new ChangeCommand((OsmPrimitive)oldRelation, (OsmPrimitive)newRelation));
        }
        return commands;
    }
}

