/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant;

import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.pt_assistant.actions.AddStopPositionAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.CreatePlatformNodeAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.CreatePlatformNodeThroughReplaceAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.CreatePlatformShortcutAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.DoubleSplitAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.EdgeSelectionAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.EditHighlightedRelationsAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.ExtractPlatformNodeAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.PTWizardAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.RepeatLastFixAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SortPTRouteMembersAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SplitRoundaboutAction;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayerManager;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantPreferenceSetting;
import org.openstreetmap.josm.plugins.pt_assistant.validation.BicycleFootRouteValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.tools.I18n;

public class PTAssistantPlugin
extends Plugin {
    private static PTRouteSegment lastFix;
    private static List<Relation> highlightedRelations;
    private static JMenuItem repeatLastFixMenu;
    private static JMenuItem editHighlightedRelationsMenu;

    public PTAssistantPlugin(PluginInformation info) {
        super(info);
        OsmValidator.addTest(PTAssistantValidatorTest.class);
        OsmValidator.addTest(BicycleFootRouteValidatorTest.class);
        MainMenu menu = MainApplication.getMenu();
        JMenu PublicTransportMenu = menu.addMenu("File", I18n.trc((String)"menu", (String)"Public Transport"), 80, 5, HelpUtil.ht((String)"/Menu/Public Transport"));
        DataSet.addSelectionListener((SelectionChangedListener)PTAssistantLayerManager.PTLM);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PTAssistantLayerManager.PTLM);
        this.addToPTAssistantmenu(PublicTransportMenu);
        PTAssistantPlugin.initialiseWizard();
        PTAssistantPlugin.initialiseShorcutsForCreatePlatformNode();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            repeatLastFixMenu.setEnabled(false);
            editHighlightedRelationsMenu.setEnabled(false);
            MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new AddStopPositionAction())));
            MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new EdgeSelectionAction())));
            MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new DoubleSplitAction())));
        } else if (oldFrame != null && newFrame == null) {
            repeatLastFixMenu.setEnabled(false);
            editHighlightedRelationsMenu.setEnabled(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PTAssistantPreferenceSetting();
    }

    public static PTRouteSegment getLastFix() {
        return lastFix;
    }

    public static void setLastFix(PTRouteSegment segment) {
        lastFix = segment;
        SwingUtilities.invokeLater(() -> repeatLastFixMenu.setEnabled(segment != null));
    }

    public static void setLastFixNoGui(PTRouteSegment segment) {
        lastFix = segment;
    }

    public static List<Relation> getHighlightedRelations() {
        return new ArrayList<Relation>(highlightedRelations);
    }

    public static void addHighlightedRelation(Relation highlightedRelation) {
        highlightedRelations.add(highlightedRelation);
        if (!editHighlightedRelationsMenu.isEnabled()) {
            SwingUtilities.invokeLater(() -> editHighlightedRelationsMenu.setEnabled(true));
        }
    }

    public static void clearHighlightedRelations() {
        highlightedRelations.clear();
        SwingUtilities.invokeLater(() -> editHighlightedRelationsMenu.setEnabled(false));
    }

    private void addToPTAssistantmenu(JMenu PublicTransportMenu) {
        RepeatLastFixAction repeatLastFixAction = new RepeatLastFixAction();
        EditHighlightedRelationsAction editHighlightedRelationsAction = new EditHighlightedRelationsAction();
        repeatLastFixMenu = MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)repeatLastFixAction);
        editHighlightedRelationsMenu = MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)editHighlightedRelationsAction);
        MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)new SplitRoundaboutAction());
        MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)new CreatePlatformNodeAction());
        MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)new SortPTRouteMembersAction());
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        PublicTransportMenu.add(sep);
        MainMenu.add((JMenu)PublicTransportMenu, (JosmAction)new PTWizardAction());
    }

    private static void initialiseWizard() {
        PTWizardAction wizard = new PTWizardAction();
        wizard.noDialogBox = true;
        wizard.actionPerformed(null);
    }

    private static void initialiseShorcutsForCreatePlatformNode() {
        CreatePlatformShortcutAction shortcut1 = new CreatePlatformShortcutAction();
        CreatePlatformNodeThroughReplaceAction shortcut2 = new CreatePlatformNodeThroughReplaceAction();
        ExtractPlatformNodeAction shortcut3 = new ExtractPlatformNodeAction();
    }

    static {
        highlightedRelations = new ArrayList<Relation>();
    }
}

