/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class IntersectedWaysRecursiveAction
extends JosmAction {
    public IntersectedWaysRecursiveAction() {
        super(I18n.tr((String)"All intersecting ways", (Object[])new Object[0]), "intwayall", I18n.tr((String)"Select all intersecting ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:intwayall", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"All intersecting ways"}), (int)106, (int)5006), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAllIntersectingWays"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        Set selectedWays = OsmPrimitive.getFilteredSet((Collection)ds.getSelected(), Way.class);
        if (!selectedWays.isEmpty()) {
            HashSet<Way> newWays = new HashSet<Way>();
            NodeWayUtils.addWaysIntersectingWaysRecursively(ds.getWays(), selectedWays, newWays);
            ds.addSelected(newWays);
        } else {
            new Notification(I18n.tr((String)"Please select some ways to find all connected and intersecting ways!", (Object[])new Object[0])).setIcon(2).show();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

