/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DownloadChosenRelationAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public DownloadChosenRelationAction(ChosenRelation rel) {
        this.putValue("SmallIcon", ImageProvider.get((String)"relcontext", (String)"download"));
        this.putValue("ShortDescription", I18n.tr((String)"Download incomplete members for the chosen relation", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation relation = this.rel.get();
        if (relation == null || relation.isNew()) {
            return;
        }
        int total = relation.getMembersCount();
        int incomplete = relation.getIncompleteMembers().size();
        if (incomplete <= 10 && incomplete * 3 < total) {
            this.downloadIncomplete(relation);
        } else {
            this.downloadMembers(relation);
        }
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        boolean incomplete = false;
        if (newRelation != null) {
            for (RelationMember m : newRelation.getMembers()) {
                if (!m.getMember().isIncomplete()) continue;
                incomplete = true;
                break;
            }
        }
        this.setEnabled(newRelation != null && incomplete);
    }

    protected void downloadMembers(Relation rel) {
        if (!rel.isNew()) {
            MainApplication.worker.submit((Runnable)new DownloadRelationTask(Collections.singletonList(rel), MainApplication.getLayerManager().getEditLayer()));
        }
    }

    protected void downloadIncomplete(Relation rel) {
        if (rel.isNew()) {
            return;
        }
        HashSet ret = new HashSet();
        ret.addAll(rel.getIncompleteMembers());
        if (ret.isEmpty()) {
            return;
        }
        MainApplication.worker.submit((Runnable)new DownloadRelationMemberTask(Collections.singletonList(rel), ret, MainApplication.getLayerManager().getEditLayer()));
    }
}

