/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.CalibrationLayer;
import iodb.CalibrationObject;
import iodb.DeprecateOffsetAction;
import iodb.ImageryOffset;
import iodb.ImageryOffsetBase;
import iodb.ImageryOffsetTools;
import iodb.ImageryOffsetWatcher;
import iodb.OffsetDialogButton;
import iodb.OffsetInfoAction;
import iodb.QuerySuccessListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OffsetDialog
extends JDialog
implements ActionListener,
NavigatableComponent.ZoomChangeListener,
MapViewPaintable {
    protected static final String PREF_CALIBRATION = "iodb.show.calibration";
    protected static final String PREF_DEPRECATED = "iodb.show.deprecated";
    private static final int MAX_OFFSETS = Main.pref.getInt("iodb.max.offsets", 4);
    private static final boolean MODAL = false;
    private List<ImageryOffsetBase> offsets;
    private ImageryOffsetBase selectedOffset;
    private JPanel buttonPanel;

    public OffsetDialog(List<ImageryOffsetBase> offsets) {
        super((Window)JOptionPane.getFrameForComponent(Main.parent), ImageryOffsetTools.DIALOG_TITLE, Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.offsets = offsets;
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void prepareDialog() {
        this.updateButtonPanel();
        final JCheckBox calibrationBox = new JCheckBox(I18n.tr((String)"Calibration geometries", (Object[])new Object[0]));
        calibrationBox.setSelected(Main.pref.getBoolean(PREF_CALIBRATION, true));
        calibrationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.pref.putBoolean(OffsetDialog.PREF_CALIBRATION, calibrationBox.isSelected());
                OffsetDialog.this.updateButtonPanel();
            }
        });
        final JCheckBox deprecatedBox = new JCheckBox(I18n.tr((String)"Deprecated offsets", (Object[])new Object[0]));
        deprecatedBox.setSelected(Main.pref.getBoolean(PREF_DEPRECATED, false));
        deprecatedBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.pref.putBoolean(OffsetDialog.PREF_DEPRECATED, deprecatedBox.isSelected());
                OffsetDialog.this.updateButtonPanel();
            }
        });
        Box checkBoxPanel = new Box(0);
        checkBoxPanel.add(calibrationBox);
        checkBoxPanel.add(deprecatedBox);
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]), ImageProvider.get((String)"cancel"));
        cancelButton.addActionListener(this);
        JButton helpButton = new JButton(new HelpAction());
        JPanel cancelPanel = new JPanel(new FlowLayout(1));
        cancelPanel.add(cancelButton);
        cancelPanel.add(helpButton);
        Box dialog = new Box(1);
        dialog.add(this.buttonPanel);
        dialog.add(checkBoxPanel);
        dialog.add(cancelPanel);
        dialog.setBorder(new CompoundBorder(dialog.getBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.setContentPane(dialog);
        this.pack();
        this.setLocationRelativeTo(Main.parent);
    }

    private void updateButtonPanel() {
        List<ImageryOffsetBase> filteredOffsets = this.filterOffsets();
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        this.buttonPanel.removeAll();
        this.buttonPanel.setLayout(new GridLayout(filteredOffsets.size(), 1, 0, 5));
        for (ImageryOffsetBase offset : filteredOffsets) {
            OffsetDialogButton button = new OffsetDialogButton(offset);
            button.addActionListener(this);
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new OffsetInfoAction(offset));
            if (!offset.isDeprecated()) {
                DeprecateOffsetAction action = new DeprecateOffsetAction(offset);
                action.setListener(new DeprecateOffsetListener(offset));
                popupMenu.add(action);
            }
            button.setComponentPopupMenu(popupMenu);
            this.buttonPanel.add(button);
        }
        this.pack();
        MainApplication.getMap().mapView.repaint();
    }

    private List<ImageryOffsetBase> filterOffsets() {
        boolean showCalibration = Main.pref.getBoolean(PREF_CALIBRATION, true);
        boolean showDeprecated = Main.pref.getBoolean(PREF_DEPRECATED, false);
        ArrayList<ImageryOffsetBase> filteredOffsets = new ArrayList<ImageryOffsetBase>();
        for (ImageryOffsetBase offset : this.offsets) {
            if (offset.isDeprecated() && !showDeprecated || offset instanceof CalibrationObject && !showCalibration) continue;
            filteredOffsets.add(offset);
            if (filteredOffsets.size() < MAX_OFFSETS) continue;
            break;
        }
        return filteredOffsets;
    }

    public void zoomChanged() {
        for (Component c : this.buttonPanel.getComponents()) {
            if (!(c instanceof OffsetDialogButton)) continue;
            ((OffsetDialogButton)c).updateLocation();
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.offsets == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.0f));
        for (ImageryOffsetBase offset : this.filterOffsets()) {
            Point p = mv.getPoint(offset.getPosition());
            g2.setColor(Color.BLACK);
            g2.fillOval(p.x - 2, p.y - 2, 5, 5);
            g2.setColor(Color.WHITE);
            g2.drawOval(p.x - 3, p.y - 3, 7, 7);
        }
    }

    public ImageryOffsetBase showDialog() {
        this.selectedOffset = null;
        this.prepareDialog();
        MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        MainApplication.getMap().mapView.addTemporaryLayer((MapViewPaintable)this);
        MainApplication.getMap().mapView.repaint();
        this.setVisible(true);
        return this.selectedOffset;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean closeDialog;
        this.selectedOffset = e.getSource() instanceof OffsetDialogButton ? ((OffsetDialogButton)e.getSource()).getOffset() : null;
        boolean bl = closeDialog = this.selectedOffset == null || this.selectedOffset instanceof CalibrationObject || Main.pref.getBoolean("iodb.close.on.select", true);
        if (closeDialog) {
            MapView.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            this.setVisible(false);
        }
        if (closeDialog) {
            MainApplication.getMap().mapView.removeTemporaryLayer((MapViewPaintable)this);
            MainApplication.getMap().mapView.repaint();
        }
        if (this.selectedOffset != null) {
            this.applyOffset();
            if (!closeDialog) {
                this.updateButtonPanel();
            }
        }
    }

    public void applyOffset() {
        if (this.selectedOffset instanceof ImageryOffset) {
            AbstractTileSourceLayer layer = ImageryOffsetTools.getTopImageryLayer();
            ImageryOffsetTools.applyLayerOffset(layer, (ImageryOffset)this.selectedOffset);
            ImageryOffsetWatcher.getInstance().markGood();
            MainApplication.getMap().repaint();
            if (!Main.pref.getBoolean("iodb.offset.message", false)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The topmost imagery layer has been shifted to presumably match\nOSM data in the area. Please check that the offset is still valid\nby downloading GPS tracks and comparing them and OSM data to the imagery.", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 1);
                Main.pref.putBoolean("iodb.offset.message", true);
            }
        } else if (this.selectedOffset instanceof CalibrationObject) {
            CalibrationLayer clayer = new CalibrationLayer((CalibrationObject)this.selectedOffset);
            MainApplication.getLayerManager().addLayer((Layer)clayer);
            clayer.panToCenter();
            if (!Main.pref.getBoolean("iodb.calibration.message", false)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"A layer has been added with a calibration geometry. Hide data layers,\nfind the corresponding feature on the imagery layer and move it accordingly.", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 1);
                Main.pref.putBoolean("iodb.calibration.message", true);
            }
        }
    }

    static class HelpAction
    extends AbstractAction {
        HelpAction() {
            super(I18n.tr((String)"Help", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"help"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String base = Main.pref.get("url.openstreetmap-wiki", "https://wiki.openstreetmap.org/wiki/");
            String lang = LanguageInfo.getWikiLanguagePrefix();
            String page = "Imagery_Offset_Database";
            try {
                HttpClient.Response conn = HttpClient.create((URL)new URL(base + lang + page), (String)"HEAD").connect();
                if (conn.getResponseCode() != 200) {
                    conn.disconnect();
                    lang = "";
                }
            }
            catch (IOException ex) {
                lang = "";
            }
            OpenBrowser.displayUrl((String)(base + lang + page));
        }
    }

    private class DeprecateOffsetListener
    implements QuerySuccessListener {
        ImageryOffsetBase offset;

        DeprecateOffsetListener(ImageryOffsetBase offset) {
            this.offset = offset;
        }

        @Override
        public void queryPassed() {
            this.offset.setDeprecated(new Date(), UserIdentityManager.getInstance().getUserName(), "");
            OffsetDialog.this.updateButtonPanel();
        }
    }
}

