/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDPatternResources;
import org.apache.pdfbox.pdmodel.graphics.shading.AxialShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType1;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;
import org.apache.pdfbox.pdmodel.graphics.shading.RadialShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type1ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type4ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type5ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type6ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.shading.Type7ShadingPaint;
import org.apache.pdfbox.util.Matrix;

public class PDShadingPatternResources
extends PDPatternResources {
    private PDExtendedGraphicsState extendedGraphicsState;
    private PDShadingResources shading;
    private COSArray matrix = null;
    private static final Log LOG = LogFactory.getLog(PDShadingPatternResources.class);

    public PDShadingPatternResources() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 2);
    }

    public PDShadingPatternResources(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    public int getPatternType() {
        return 2;
    }

    public Matrix getMatrix() {
        Matrix returnMatrix = null;
        if (this.matrix == null) {
            this.matrix = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.MATRIX);
        }
        if (this.matrix != null) {
            returnMatrix = new Matrix();
            returnMatrix.setValue(0, 0, ((COSNumber)this.matrix.get(0)).floatValue());
            returnMatrix.setValue(0, 1, ((COSNumber)this.matrix.get(1)).floatValue());
            returnMatrix.setValue(1, 0, ((COSNumber)this.matrix.get(2)).floatValue());
            returnMatrix.setValue(1, 1, ((COSNumber)this.matrix.get(3)).floatValue());
            returnMatrix.setValue(2, 0, ((COSNumber)this.matrix.get(4)).floatValue());
            returnMatrix.setValue(2, 1, ((COSNumber)this.matrix.get(5)).floatValue());
        }
        return returnMatrix;
    }

    public void setMatrix(AffineTransform transform) {
        this.matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.matrix.add(new COSFloat((float)v));
        }
        this.getCOSDictionary().setItem(COSName.MATRIX, (COSBase)this.matrix);
    }

    public PDExtendedGraphicsState getExtendedGraphicsState() {
        COSDictionary dictionary;
        if (this.extendedGraphicsState == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.EXT_G_STATE)) != null) {
            this.extendedGraphicsState = new PDExtendedGraphicsState(dictionary);
        }
        return this.extendedGraphicsState;
    }

    public void setExtendedGraphicsState(PDExtendedGraphicsState extendedGraphicsState) {
        this.extendedGraphicsState = extendedGraphicsState;
        if (extendedGraphicsState != null) {
            this.getCOSDictionary().setItem(COSName.EXT_G_STATE, (COSObjectable)extendedGraphicsState);
        } else {
            this.getCOSDictionary().removeItem(COSName.EXT_G_STATE);
        }
    }

    public PDShadingResources getShading() throws IOException {
        COSDictionary dictionary;
        if (this.shading == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.SHADING)) != null) {
            this.shading = PDShadingResources.create(dictionary);
        }
        return this.shading;
    }

    public void setShading(PDShadingResources shadingResources) {
        this.shading = shadingResources;
        if (shadingResources != null) {
            this.getCOSDictionary().setItem(COSName.SHADING, (COSObjectable)shadingResources);
        } else {
            this.getCOSDictionary().removeItem(COSName.SHADING);
        }
    }

    public Paint getPaint(int pageHeight) throws IOException {
        Paint paint = null;
        PDShadingResources shadingResources = this.getShading();
        int shadingType = shadingResources != null ? shadingResources.getShadingType() : 0;
        switch (shadingType) {
            case 1: {
                paint = new Type1ShadingPaint((PDShadingType1)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 2: {
                paint = new AxialShadingPaint((PDShadingType2)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 3: {
                paint = new RadialShadingPaint((PDShadingType3)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 4: {
                paint = new Type4ShadingPaint((PDShadingType4)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 5: {
                paint = new Type5ShadingPaint((PDShadingType5)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 6: {
                paint = new Type6ShadingPaint((PDShadingType6)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            case 7: {
                paint = new Type7ShadingPaint((PDShadingType7)this.getShading(), this.getMatrix(), pageHeight);
                break;
            }
            default: {
                throw new IOException("Error: Unknown shading type " + shadingType);
            }
        }
        return paint;
    }
}

